/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.TextComponentData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextComponentElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.item.RepairKitItem;

public abstract class AbstractMaterialContent
extends PageContent {
    private static final List<Component> PART_BUILDER = List.of(TConstruct.makeTranslation("book", "material.craftable"), TConstruct.makeTranslation("book", "material.part_builder").m_130940_(ChatFormatting.GRAY));
    private static final Component CASTABLE = TConstruct.makeTranslation("book", "material.castable");
    private static final String CAST_FROM = TConstruct.makeTranslationKey("book", "material.cast_from");
    private static final Component COMPOSITE = TConstruct.makeTranslation("book", "material.composite");
    private static final String COMPOSITE_FROM = TConstruct.makeTranslationKey("book", "material.composite_from");
    static final int COLUMN_MARGIN = 22;
    static final int STAT_WIDTH = 81;
    private transient MaterialVariantId materialVariant;
    private transient List<ItemStack> repairStacks;
    private transient IMaterial material;
    public String title = "";
    @SerializedName(value="material")
    public String materialName = "";
    public boolean detailed = false;
    @SerializedName(value="show_all_tools")
    public boolean showAllTools = false;
    private static List<IToolPart> ALL_PARTS = null;

    public AbstractMaterialContent(MaterialVariantId materialVariant, boolean detailed) {
        this.materialName = materialVariant.toString();
        this.materialVariant = materialVariant;
        this.detailed = detailed;
    }

    public abstract ResourceLocation getId();

    @Nullable
    protected abstract MaterialStatsId getStatType(int var1);

    protected abstract String getTextKey(MaterialId var1);

    protected abstract boolean supportsStatType(MaterialStatsId var1);

    protected MaterialVariantId getMaterialVariant() {
        if (this.materialVariant == null) {
            this.materialVariant = MaterialVariantId.parse(this.materialName);
        }
        return this.materialVariant;
    }

    protected IMaterial getMaterial() {
        if (this.material == null) {
            this.material = MaterialRegistry.getMaterial(this.getMaterialVariant().getId());
        }
        return this.material;
    }

    protected List<ItemStack> getRepairStacks() {
        if (this.repairStacks == null) {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return Collections.emptyList();
            }
            MaterialVariantId material = this.getMaterialVariant();
            this.repairStacks = RecipeHelper.getUIRecipes((RecipeManager)world.m_7465_(), (RecipeType)((RecipeType)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class, recipe -> material.matchesVariant(recipe.getMaterial())).stream().flatMap(recipe -> Arrays.stream(recipe.getIngredient().m_43908_())).collect(Collectors.toList());
            if (this.repairStacks.isEmpty()) {
                TConstruct.LOG.debug("Material with id " + material + " has no representation items associated with it, using repair kit");
                this.repairStacks = Collections.singletonList(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(material));
            }
        }
        return this.repairStacks;
    }

    public List<ItemStack> getDisplayStacks() {
        return this.getRepairStacks();
    }

    @Nonnull
    public String getTitle() {
        if (this.title.isEmpty()) {
            return this.getTitleComponent().getString();
        }
        return this.title;
    }

    public Component getTitleComponent() {
        return MaterialTooltipCache.getDisplayName(this.getMaterialVariant());
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        MaterialVariantId materialVariant = this.getMaterialVariant();
        this.addTitle(list, this.getTitle(), true, MaterialTooltipCache.getColor(materialVariant).m_131265_());
        this.addDisplayItems(list, rightSide ? 164 : 0, materialVariant);
        int y = this.getTitleHeight();
        int x = (rightSide ? 0 : 22) + 2;
        y = this.addAllMaterialStats(x, y, list, 2, true);
        this.addDescription(x, y, list);
    }

    protected int addAllMaterialStats(int x, int y, List<BookElement> list, int rows, boolean includeStats) {
        for (int i = 0; i < rows; ++i) {
            y = Math.max(this.addMaterialStat(x - 3, y, 81, list, this.getStatType(i * 2), includeStats), this.addMaterialStat(x + 81, y, 81, list, this.getStatType(i * 2 + 1), includeStats));
        }
        return y;
    }

    protected int addMaterialStat(int x, int y, int w, List<BookElement> list, @Nullable MaterialStatsId statsId, boolean includeStats) {
        MaterialVariantId material;
        if (statsId == null) {
            return y;
        }
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        Optional stats = registry.getMaterialStats((material = this.getMaterialVariant()).getId(), statsId);
        if (stats.isEmpty()) {
            return y;
        }
        List<ItemStack> parts = AbstractMaterialContent.getPartsWithMaterial(material, statsId);
        int textOffset = 0;
        if (!parts.isEmpty()) {
            TinkerItemElement display = new TinkerItemElement(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
            textOffset = 10;
        }
        list.add((BookElement)new TextComponentElement(x + textOffset, y, w - textOffset, 10, (Component)((IMaterialStats)stats.get()).getLocalizedName().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE})));
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        if (includeStats) {
            AbstractMaterialContent.addStatLines(lineData, (IMaterialStats)stats.get());
        }
        AbstractMaterialContent.addTraitLines(lineData, registry.getTraits(material.getId(), statsId));
        list.add((BookElement)new TextComponentElement(x, y, w, 176, (Collection)lineData));
        return y + lineData.size() * 5 + 3;
    }

    private static void addStatLines(List<TextComponentData> lineData, IMaterialStats stats) {
        List<Component> statInfo = stats.getLocalizedInfo();
        List<Component> tooltips = stats.getLocalizedDescriptions();
        int size = Math.min(statInfo.size(), tooltips.size());
        for (int i = 0; i < size; ++i) {
            Component tooltip = tooltips.get(i);
            TextComponentData text = new TextComponentData(statInfo.get(i));
            text.tooltips = tooltip.getString().isEmpty() ? null : new Component[]{tooltip};
            lineData.add(text);
            lineData.add(new TextComponentData("\n"));
        }
    }

    protected static void addTraitLines(List<TextComponentData> lineData, List<ModifierEntry> traits) {
        for (ModifierEntry trait : traits) {
            Modifier mod = trait.getModifier();
            TextComponentData textComponentData = new TextComponentData(mod.getDisplayName());
            List<Component> textComponents = mod.getDescriptionList(trait.getLevel());
            textComponentData.tooltips = textComponents.toArray(new Component[0]);
            textComponentData.text = textComponentData.text.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.UNDERLINE});
            lineData.add(textComponentData);
            lineData.add(new TextComponentData("\n"));
        }
    }

    protected static TinkerItemElement makeCategoryIcon(ItemStack item, ResourceLocation name) {
        TinkerItemElement element = new TinkerItemElement(item);
        name = name.m_246208_("material.category.");
        element.tooltip = List.of(Component.m_237115_((String)Util.makeTranslationKey("book", name)), Component.m_237115_((String)Util.makeTranslationKey("book", name.m_266382_(".description"))).m_130940_(ChatFormatting.GRAY));
        return element;
    }

    protected void addCategory(List<ItemElement> displayTools, MaterialId material) {
    }

    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<MaterialFluidRecipe> fluids;
        TinkerItemElement elementItem;
        if (this.getMaterial().isCraftable()) {
            ItemStack partBuilder = new ItemStack((ItemLike)TinkerTables.partBuilder.m_5456_());
            elementItem = new TinkerItemElement(partBuilder);
            elementItem.tooltip = PART_BUILDER;
            displayTools.add(elementItem);
        }
        if (!(fluids = MaterialCastingLookup.getCastingFluids(materialId)).isEmpty()) {
            elementItem = new TinkerItemElement(0, 0, 1.0f, fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).map(fluid -> new ItemStack((ItemLike)fluid.getFluid().m_6859_())).collect(Collectors.toList()));
            FluidStack firstFluid = fluids.stream().flatMap(recipe -> recipe.getFluids().stream()).findFirst().orElse(FluidStack.EMPTY);
            elementItem.tooltip = List.of(CASTABLE, Component.m_237110_((String)CAST_FROM, (Object[])new Object[]{firstFluid.getDisplayName()}).m_130940_(ChatFormatting.GRAY));
            displayTools.add(elementItem);
        }
        List<MaterialFluidRecipe> composites = MaterialCastingLookup.getCompositeFluids(materialId);
        for (MaterialFluidRecipe composite : composites) {
            MaterialVariant input = composite.getInput();
            if (input == null || this.materialVariant.matchesVariant(input.getVariant())) continue;
            MaterialVariantId inputId = input.getVariant();
            TinkerItemElement elementItem2 = new TinkerItemElement(0, 0, 1.0f, MaterialCastingLookup.getAllItemCosts().stream().map(Map.Entry::getKey).filter(part -> part.canUseMaterial(inputId.getId()) && part.canUseMaterial(this.material)).map(part -> part.withMaterial(inputId)).collect(Collectors.toList()));
            FluidStack firstFluid = composite.getFluids().stream().findFirst().orElse(FluidStack.EMPTY);
            elementItem2.tooltip = List.of(COMPOSITE, Component.m_237110_((String)COMPOSITE_FROM, (Object[])new Object[]{firstFluid.getDisplayName(), MaterialTooltipCache.getDisplayName(inputId)}).m_130940_(ChatFormatting.GRAY));
            displayTools.add(elementItem2);
        }
    }

    protected void addDisplayItems(ArrayList<BookElement> list, int x, MaterialVariantId materialVariant) {
        ArrayList displayTools = Lists.newArrayList();
        this.addCategory(displayTools, materialVariant.getId());
        displayTools.add(new TinkerItemElement(0, 0, 1.0f, this.getRepairStacks()));
        this.addPrimaryDisplayItems(displayTools, materialVariant);
        if (displayTools.size() < 9) {
            MaterialId materialId = materialVariant.getId();
            block0: for (Holder item : BuiltInRegistries.f_257033_.m_206058_(TinkerTags.Items.MULTIPART_TOOL)) {
                Object object = item.m_203334_();
                if (!(object instanceof IModifiable)) continue;
                IModifiable tool = (IModifiable)object;
                List<MaterialStatsId> requirements = ToolMaterialHook.stats(tool.getToolDefinition());
                MaterialNBT.Builder materials = MaterialNBT.builder();
                boolean usedMaterial = false;
                for (MaterialStatsId part : requirements) {
                    boolean supported = this.supportsStatType(part);
                    if (!this.showAllTools && !supported) continue block0;
                    if (part.canUseMaterial(materialId)) {
                        materials.add(materialVariant);
                        if (!supported) continue;
                        usedMaterial = true;
                        continue;
                    }
                    materials.add(MaterialRegistry.firstWithStatType(part));
                }
                if (!usedMaterial) continue;
                ItemStack display = ToolBuildHandler.buildItemFromMaterials(tool, materials.build());
                displayTools.add(new TinkerItemElement(display));
                if (displayTools.size() != 9) continue;
                break;
            }
        }
        if (!displayTools.isEmpty()) {
            int y = this.getTitleHeight() - 5;
            for (ItemElement element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }

    protected void addDescription(int x, int y, List<BookElement> list) {
        String textKey = this.getTextKey(this.materialVariant.getId());
        if (I18n.m_118936_((String)textKey)) {
            Object translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = "\"" + (String)translated + "\"";
            }
            TextData flavourData = new TextData((String)translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x - 3, y + 5, 155, 60, new TextData[]{flavourData}));
        }
    }

    private static List<IToolPart> getToolParts() {
        if (ALL_PARTS == null) {
            ALL_PARTS = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, TinkerTags.Items.TOOL_PARTS).filter(item -> item instanceof IToolPart).map(item -> (IToolPart)item).toList();
        }
        return ALL_PARTS;
    }

    private static List<ItemStack> getPartsWithMaterial(MaterialVariantId material, MaterialStatsId statType) {
        return AbstractMaterialContent.getToolParts().stream().filter(part -> part.getStatType().equals((Object)statType)).map(part -> part.withMaterialForDisplay(material)).toList();
    }
}

