/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.AdvancementsProvider;
import slimeknights.tconstruct.common.data.DamageTypeProvider;
import slimeknights.tconstruct.common.data.loot.GlobalLootModifiersProvider;
import slimeknights.tconstruct.common.data.loot.LootTableInjectionProvider;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BiomeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockEntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.DamageTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.EnchantmentTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.data.tags.MenuTypeTagProvider;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerItemDisplays;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.plugin.DietPlugin;
import slimeknights.tconstruct.plugin.ImmersiveEngineeringPlugin;
import slimeknights.tconstruct.plugin.craftingtweaks.CraftingTweaksPlugin;
import slimeknights.tconstruct.plugin.jsonthings.JsonThingsPlugin;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.material.TrimMaterialProvider;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.data.WorldgenProvider;

@Mod(value="tconstruct")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TConstruct {
    public static final String MOD_ID = "tconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"tconstruct");
    public static final Random RANDOM = new Random();
    public static TConstruct instance;

    public TConstruct() {
        instance = this;
        Config.init();
        TinkerItemDisplays.init();
        MinecraftForge.EVENT_BUS.addListener(TConstruct::missingMappings);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)new TinkerCommons());
        bus.register((Object)new TinkerMaterials());
        bus.register((Object)new TinkerEffects());
        bus.register((Object)new TinkerGadgets());
        bus.register((Object)new TinkerAttributes());
        bus.register((Object)new TinkerWorld());
        bus.register((Object)new TinkerStructures());
        bus.register((Object)new TinkerTables());
        bus.register((Object)new TinkerModifiers());
        bus.register((Object)new TinkerToolParts());
        bus.register((Object)new TinkerTools());
        bus.register((Object)new TinkerSmeltery());
        bus.register((Object)new TinkerFluids());
        TinkerModule.initRegisters();
        TinkerNetwork.setup();
        TinkerTags.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TinkerClient::onConstruct);
        ModList modList = ModList.get();
        if (modList.isLoaded("immersiveengineering")) {
            bus.register((Object)new ImmersiveEngineeringPlugin());
        }
        if (modList.isLoaded("jsonthings")) {
            JsonThingsPlugin.onConstruct();
        }
        if (modList.isLoaded("diet")) {
            DietPlugin.onConstruct();
        }
        if (modList.isLoaded("craftingtweaks")) {
            CraftingTweaksPlugin.onConstruct();
        }
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MaterialRegistry.init();
        ToolDefinitionLoader.init();
        StationSlotLayoutLoader.init();
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean server = event.includeServer();
        RegistrySetBuilder registrySetBuilder = new RegistrySetBuilder();
        DamageTypeProvider.register(registrySetBuilder);
        WorldgenProvider.register(registrySetBuilder);
        TrimMaterialProvider.register(registrySetBuilder);
        DatapackBuiltinEntriesProvider datapackRegistryProvider = new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, registrySetBuilder, Set.of(MOD_ID));
        generator.addProvider(server, (DataProvider)datapackRegistryProvider);
        BlockTagProvider blockTags = new BlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new ItemTagProvider(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(server, (DataProvider)new FluidTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new EntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new BlockEntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new BiomeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new EnchantmentTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new MenuTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(server, (DataProvider)new DamageTypeTagProvider(packOutput, datapackRegistryProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(server, (DataProvider)new TConstructLootTableProvider(packOutput));
        generator.addProvider(server, (DataProvider)new AdvancementsProvider(packOutput));
        generator.addProvider(server, (DataProvider)new GlobalLootModifiersProvider(packOutput));
        generator.addProvider(server, (DataProvider)new LootTableInjectionProvider(packOutput));
    }

    private static void missingMappings(MissingMappingsEvent event) {
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registries.f_256747_, name -> switch (name) {
            case "piglin_head" -> Blocks.f_260630_;
            case "piglin_wall_head" -> Blocks.f_260585_;
            default -> null;
        });
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registries.f_256913_, name -> switch (name) {
            case "piglin_head" -> Items.f_260451_;
            case "round_plate" -> (ToolPartItem)TinkerToolParts.adzeHead.get();
            case "round_plate_cast" -> (Item)TinkerSmeltery.adzeHeadCast.get();
            case "round_plate_sand_cast" -> TinkerSmeltery.adzeHeadCast.getSand();
            case "round_plate_red_sand_cast" -> TinkerSmeltery.adzeHeadCast.getRedSand();
            default -> null;
        });
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of(TConstruct.getResource(name));
    }

    public static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of(TConstruct.getResource(name), constructor);
    }

    public static String resourceString(String res) {
        return String.format("%s:%s", MOD_ID, res);
    }

    public static String prefix(String name) {
        return "tconstruct." + name.toLowerCase(Locale.US);
    }

    public static String makeDescriptionId(String type, String name) {
        return type + ".tconstruct." + name;
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey(base, TConstruct.getResource(name));
    }

    public static MutableComponent makeTranslation(String base, String name) {
        return Component.m_237115_((String)TConstruct.makeTranslationKey(base, name));
    }

    public static MutableComponent makeTranslation(String base, String name, Object ... arguments) {
        return Component.m_237110_((String)TConstruct.makeTranslationKey(base, name), (Object[])arguments);
    }

    public static void sealTinkersClass(Object self, String base, String solution) {
        String name = self.getClass().getName();
        if (!name.startsWith("slimeknights.tconstruct.")) {
            throw new IllegalStateException(base + " being extended from invalid package " + name + ". " + solution);
        }
    }
}

