/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialValueIngredient;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.recipe.material.ShapedMaterialRecipe;

public class ShapedMaterialExtension
implements ICraftingCategoryExtension {
    private final ShapedMaterialRecipe recipe;
    private final ItemStack plainResult;
    private final List<ItemStack> result;
    private final int[] materialSlots;

    public ShapedMaterialExtension(ShapedMaterialRecipe recipe) {
        this.recipe = recipe;
        MaterialValueIngredient materials = recipe.getMaterial();
        this.plainResult = recipe.m_8043_(Objects.requireNonNull(SafeClientAccess.getRegistryAccess()));
        this.result = materials != null ? MaterialRecipeCache.getAllRecipes().stream().filter(materials::test).flatMap(mat -> {
            ItemStack stack = this.plainResult.m_41777_();
            ShapedMaterialRecipe.setMaterial(stack, mat.getMaterial().getVariant());
            return IntStream.range(0, mat.getIngredient().m_43908_().length).mapToObj(i -> stack);
        }).toList() : List.of(this.plainResult);
        NonNullList inputs = recipe.m_7527_();
        this.materialSlots = IntStream.range(0, inputs.size()).filter(arg_0 -> ShapedMaterialExtension.lambda$new$2((List)inputs, arg_0)).toArray();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focusGroup) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(this.plainResult);
        List<List> inputStacks = this.recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        int width = this.recipe.m_44220_();
        int height = this.recipe.m_44221_();
        List inputs = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputStacks, width, height);
        IRecipeSlotBuilder output = craftingGridHelper.createAndSetOutputs(builder, this.result);
        if (inputs.size() != 9) {
            Mantle.logger.error("Failed to create focus link for {} as the layout {} is not 3x3", (Object)this.recipe.m_6423_(), (Object)builder.getClass().getName());
        } else {
            builder.createFocusLink((IIngredientAcceptor[])Streams.concat((Stream[])new Stream[]{Stream.of(output), Arrays.stream(this.materialSlots).mapToObj(i -> (IRecipeSlotBuilder)inputs.get(ShapedMaterialExtension.getCraftingIndex(i, width, height)))}).toArray(IRecipeSlotBuilder[]::new));
        }
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    private static /* synthetic */ boolean lambda$new$2(List inputs, int i) {
        return inputs.get(i) instanceof MaterialValueIngredient;
    }
}

