/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.fluid;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.build.StatBoostModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;

public class SlurpingModifier
extends Modifier
implements KeybindInteractModifierHook,
GeneralInteractionModifierHook,
UsingToolModifierHook {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final TinkerDataCapability.TinkerDataKey<SlurpingInfo> SLURP_FINISH_TIME = TConstruct.createKey("slurping_finish");

    public SlurpingModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TickEvent.PlayerTickEvent.class, this::playerTick);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ToolTankHelper.TANK_HANDLER);
        hookBuilder.addModule((HookProvider)StatBoostModule.add(ToolTankHelper.CAPACITY_STAT).eachLevel(1000.0f));
        hookBuilder.addHook(this, ModifierHooks.ARMOR_INTERACT, ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING);
    }

    private int slurp(FluidStack fluid, float level, Player player, IFluidHandler.FluidAction action) {
        if (!fluid.isEmpty()) {
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            return recipe.hasEntityEffects() ? recipe.applyToEntity(fluid, level, FluidEffectContext.builder(player.m_9236_()).user(player).target((LivingEntity)player), action) : 0;
        }
        return 0;
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        FluidStack fluid;
        if (!player.m_6144_() && this.slurp(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool), modifier.getEffectiveLevel(), player, IFluidHandler.FluidAction.SIMULATE) > 0) {
            player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(SLURP_FINISH_TIME, new SlurpingInfo(fluid, player.f_19797_ + 20)));
            return true;
        }
        return false;
    }

    private static void addFluidParticles(Player player, FluidStack fluid, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            motion = motion.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            motion = motion.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            Vec3 position = new Vec3(((double)RANDOM.nextFloat() - 0.5) * 0.3, (double)(-RANDOM.nextFloat()) * 0.6 - 0.3, 0.6);
            position = position.m_82496_(-player.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-player.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            FluidParticleData data = new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, 1, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)data, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_ + 0.05, motion.f_82481_);
        }
    }

    private void finishDrinking(IToolStackView tool, Player player) {
        if (!player.m_9236_().f_46443_) {
            FluidStack fluid = ToolTankHelper.TANK_HELPER.getFluid(tool);
            int consumed = this.slurp(fluid, tool.getModifier(this).getEffectiveLevel(), player, IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_() && consumed > 0) {
                fluid.shrink(consumed);
                ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
            }
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_5833_()) {
            return;
        }
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            SlurpingInfo info = data.get(SLURP_FINISH_TIME);
            if (info != null) {
                int timeLeft = info.finishTime - player.f_19797_;
                if (timeLeft < 0) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 16);
                    this.finishDrinking(ToolStack.from(player.m_6844_(EquipmentSlot.HEAD)), player);
                    data.remove(SLURP_FINISH_TIME);
                } else if (timeLeft % 4 == 0) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                    SlurpingModifier.addFluidParticles(player, info.fluid, 5);
                }
            }
        });
    }

    @Override
    public void stopInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot) {
        player.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.remove(SLURP_FINISH_TIME));
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && this.slurp(ToolTankHelper.TANK_HELPER.getFluid(tool), modifier.getEffectiveLevel(), player, IFluidHandler.FluidAction.SIMULATE) > 0) {
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 21;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return BlockingModifier.blockWhileCharging(tool, UseAnim.DRINK);
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        if (timeLeft % 4 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            FluidStack fluidStack = ToolTankHelper.TANK_HELPER.getFluid(tool);
            if (!fluidStack.isEmpty()) {
                SlurpingModifier.addFluidParticles(player, fluidStack, 5);
                if (modifier != activeModifier || ModifierUtil.canPerformAction(tool, ToolActions.SHIELD_BLOCK)) {
                    player.m_5496_(SoundEvents.f_11911_, 0.5f, RANDOM.nextFloat() * 0.1f + 0.9f);
                }
            }
        }
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        if (useDuration - timeLeft >= this.getUseDuration(tool, modifier) && entity instanceof Player) {
            Player player = (Player)entity;
            this.finishDrinking(tool, player);
        }
    }

    private record SlurpingInfo(FluidStack fluid, int finishTime) {
    }
}

