/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.SimpleFluidTank;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiTankModule;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolContainerScreen
extends AbstractContainerScreen<ToolContainerMenu>
implements IScreenWithFluidTank {
    private static final ResourceLocation TEXTURE = TConstruct.getResource("textures/gui/tool_inventory.png");
    private static final ElementScreen CRAFTING_SLOTS = new ElementScreen(TEXTURE, 176, 74, 54, 54, 256, 256);
    private static final ElementScreen CRAFTING_RESULT = CRAFTING_SLOTS.move(176, 20, 62, 54);
    private static final ElementScreen INVENTORY_CRAFTING = CRAFTING_SLOTS.move(176, 128, 74, 36);
    private static final ElementScreen FLUID_TANK = CRAFTING_SLOTS.move(0, 224, 176, 14);
    private static final int REPEAT_BACKGROUND_SIZE = 108;
    private static final int PLAYER_INVENTORY_START = 125;
    private static final int PLAYER_INVENTORY_HEIGHT = 96;
    private static final int SLOTS_START = 238;
    private static final int SELECTED_X = 176;
    private final int slots;
    private final int inventoryRows;
    private final int slotsInLastRow;
    @Nullable
    private final GuiTankModule tank;

    public ToolContainerScreen(ToolContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        int slots = menu.getItemHandler().getSlots();
        if (menu.isShowOffhand()) {
            ++slots;
        }
        int inventoryRows = slots / 9;
        int slotsInLastRow = slots % 9;
        if (slotsInLastRow == 0) {
            slotsInLastRow = 9;
        } else {
            ++inventoryRows;
        }
        this.slots = slots;
        this.inventoryRows = inventoryRows;
        this.slotsInLastRow = slotsInLastRow;
        int craftingHeight = menu.getCraftingHeight() * 18;
        this.f_97727_ = 113 + this.inventoryRows * 18 + craftingHeight;
        SimpleFluidTank tank = menu.getTank();
        if (tank.getCapacity() > 0) {
            this.f_97727_ += ToolContainerScreen.FLUID_TANK.h;
            this.tank = new GuiTankModule(this, tank, 8, this.f_97727_ - 96 - 9, 160, 8, true, null);
        } else {
            this.tank = null;
        }
        if (slots > 0) {
            this.f_97729_ += craftingHeight;
        }
        this.f_97731_ = this.f_97727_ - 93;
    }

    protected void m_6597_(Slot slot, int slotId, int index, ClickType type) {
        if (type == ClickType.SWAP && slot.f_40218_ == ((ToolContainerMenu)this.f_97732_).getPlayer().m_150109_() && slot.getSlotIndex() == ((ToolContainerMenu)this.f_97732_).getSlotIndex()) {
            return;
        }
        super.m_6597_(slot, slotId, index, type);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        Slot slot;
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        int craftingHeight = ((ToolContainerMenu)this.f_97732_).getCraftingHeight();
        int slotBackground = 17 + (this.inventoryRows + craftingHeight) * 18;
        if (slotBackground < 125) {
            graphics.m_280218_(TEXTURE, xStart, yStart, 0, 0, this.f_97726_, slotBackground);
        } else {
            int remainingBackground;
            graphics.m_280218_(TEXTURE, xStart, yStart, 0, 0, this.f_97726_, 125);
            int yOffset = 125;
            for (remainingBackground = slotBackground - yOffset; remainingBackground > 108; remainingBackground -= 108) {
                graphics.m_280218_(TEXTURE, xStart, yStart + yOffset, 0, 17, this.f_97726_, 108);
                yOffset += 108;
            }
            graphics.m_280218_(TEXTURE, xStart, yStart + yOffset, 0, 17, this.f_97726_, remainingBackground);
        }
        if (this.tank != null) {
            FLUID_TANK.draw(graphics, xStart, yStart + slotBackground);
            slotBackground += ToolContainerScreen.FLUID_TANK.h;
        }
        graphics.m_280218_(TEXTURE, xStart, yStart + slotBackground, 0, 125, this.f_97726_, 96);
        int craftingOffset = yStart + (this.slots == 0 ? 17 : 4);
        if (craftingHeight == 3) {
            CRAFTING_SLOTS.draw(graphics, xStart + 29, craftingOffset);
            CRAFTING_RESULT.draw(graphics, xStart + 83, craftingOffset);
        } else if (craftingHeight == 2) {
            INVENTORY_CRAFTING.draw(graphics, xStart + 51, craftingOffset);
        }
        if (this.slots > 0) {
            int rowLeft = xStart + 7;
            int rowStart = yStart + 17 - 18 + craftingHeight * 18;
            for (int i = 1; i < this.inventoryRows; ++i) {
                graphics.m_280218_(TEXTURE, rowLeft, rowStart + i * 18, 0, 238, 162, 18);
            }
            graphics.m_280218_(TEXTURE, rowLeft, rowStart + this.inventoryRows * 18, 0, 238, this.slotsInLastRow * 18, 18);
        }
        int slotIndex = ((ToolContainerMenu)this.f_97732_).getSlotIndex();
        int playerStart = ((ToolContainerMenu)this.f_97732_).getPlayerInventoryStart();
        int highlightIndex = -1;
        if (slotIndex < 9) {
            highlightIndex = playerStart + slotIndex + 27;
        } else if (slotIndex < 36) {
            highlightIndex = playerStart + slotIndex - 9;
        } else if (slotIndex == 40 && ((ToolContainerMenu)this.f_97732_).isShowOffhand()) {
            highlightIndex = playerStart - 1;
        }
        if (highlightIndex != -1 && highlightIndex < ((ToolContainerMenu)this.f_97732_).f_38839_.size()) {
            Slot slot2 = ((ToolContainerMenu)this.f_97732_).m_38853_(highlightIndex);
            graphics.m_280218_(TEXTURE, xStart + slot2.f_40220_ - 2, yStart + slot2.f_40221_ - 2, 176, 0, 20, 20);
        }
        assert (this.f_96541_ != null);
        Function spriteGetter = this.f_96541_.m_91258_(InventoryMenu.f_39692_);
        int start = ((ToolContainerMenu)this.f_97732_).getToolInventoryStart();
        int maxSlots = ((ToolContainerMenu)this.f_97732_).f_38839_.size();
        IToolStackView tool = ((ToolContainerMenu)this.f_97732_).getTool();
        List<ModifierEntry> modifiers = tool.getModifierList();
        block2: for (int modIndex = modifiers.size() - 1; modIndex >= 0; --modIndex) {
            ModifierEntry entry = modifiers.get(modIndex);
            ToolInventoryCapability.InventoryModifierHook inventory = entry.getHook(ToolInventoryCapability.HOOK);
            int size = inventory.getSlots(tool, entry);
            for (int i = 0; i < size; ++i) {
                if (start + i >= maxSlots) break block2;
                Slot slot3 = ((ToolContainerMenu)this.f_97732_).m_38853_(start + i);
                Pattern pattern = inventory.getPattern(tool, entry, i, slot3.m_6657_());
                if (pattern == null) continue;
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(pattern.getTexture());
                graphics.m_280159_(xStart + slot3.f_40220_, yStart + slot3.f_40221_, 100, 16, 16, sprite);
            }
            start += size;
        }
        if (((ToolContainerMenu)this.f_97732_).isShowOffhand() && !(slot = ((ToolContainerMenu)this.f_97732_).m_38853_(((ToolContainerMenu)this.f_97732_).getPlayerInventoryStart() - 1)).m_6657_()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(Patterns.SHIELD.getTexture());
            graphics.m_280159_(xStart + slot.f_40220_, yStart + slot.f_40221_, 100, 16, 16, sprite);
        }
        if (this.tank != null) {
            this.tank.draw(graphics);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.highlightHoveredFluid(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.f_96541_.f_91072_ != null);
        if (!(this.tank == null || button != 0 && button != 1 || ((ToolContainerMenu)this.f_97732_).m_142621_().m_41619_() || this.f_96541_.f_91074_.m_5833_() || !this.tank.tryClick((int)mouseX - this.f_97735_, (int)mouseY - this.f_97736_, button, 0))) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        if (this.tank != null) {
            return this.tank.getFluidUnderMouse(mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        return null;
    }
}

