/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.tools.TinkerModifiers;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SlotIngredientRenderer implements IIngredientRenderer<SlotType.SlotCount>
{
    INGREDIENT{

        public List<Component> getTooltip(SlotType.SlotCount slots, TooltipFlag tooltipFlag) {
            SlotType type = slots.type();
            return SlotIngredientRenderer.appendId(type, (Component)Component.m_237110_((String)KEY_INGREDIENT, (Object[])new Object[]{type.getDisplayName()}), tooltipFlag);
        }
    }
    ,
    INPUT{

        public List<Component> getTooltip(@Nullable SlotType.SlotCount slots, TooltipFlag tooltipFlag) {
            int count;
            if (slots != null && (count = slots.count()) > 0) {
                SlotType type = slots.type();
                MutableComponent text = count == 1 ? Component.m_237110_((String)KEY_SLOT, (Object[])new Object[]{type.getDisplayName()}) : Component.m_237110_((String)KEY_SLOTS, (Object[])new Object[]{count, type.getDisplayName()});
                return SlotIngredientRenderer.appendId(type, (Component)text, tooltipFlag);
            }
            return TEXT_FREE;
        }
    }
    ,
    OUTPUT{

        public List<Component> getTooltip(SlotType.SlotCount slots, TooltipFlag tooltipFlag) {
            SlotType type = slots.type();
            return SlotIngredientRenderer.appendId(type, type.format(slots.count()), tooltipFlag);
        }
    };

    private static final String KEY_SLOT;
    private static final String KEY_SLOTS;
    private static final List<Component> TEXT_FREE;
    private static final String KEY_INGREDIENT;
    private static final String KEY_ID;
    private static final Map<SlotType, TextureAtlasSprite> SLOT_SPRITES;
    private static final Function<SlotType, TextureAtlasSprite> SLOT_LOOKUP;

    public int getWidth() {
        return this == INGREDIENT ? 16 : 24;
    }

    public void render(GuiGraphics graphics, @Nullable SlotType.SlotCount slots) {
        if (this != INGREDIENT && slots != null && slots.count() > 0) {
            String text = Integer.toString(slots.count());
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            graphics.m_280056_(fontRenderer, text, 9 - fontRenderer.m_92895_(text), 5, Color.GRAY.getRGB(), false);
        }
        graphics.m_280159_(this == INGREDIENT ? 0 : 8, 0, 0, 16, 16, SLOT_SPRITES.computeIfAbsent(SlotType.SlotCount.type(slots), SLOT_LOOKUP));
    }

    private static List<Component> appendId(SlotType type, Component text, TooltipFlag tooltipFlag) {
        if (tooltipFlag.m_7050_()) {
            return List.of(text, Component.m_237110_((String)KEY_ID, (Object[])new Object[]{type.getName()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return List.of(text);
    }

    public static void clearCache() {
        SLOT_SPRITES.clear();
    }

    static {
        KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
        KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
        TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
        KEY_INGREDIENT = TConstruct.makeTranslationKey("jei", "modifier_slot.ingredient");
        KEY_ID = TConstruct.makeTranslationKey("jei", "modifier_slot.id");
        SLOT_SPRITES = new HashMap<SlotType, TextureAtlasSprite>();
        SLOT_LOOKUP = slotType -> {
            ItemOverrides patt3953$temp;
            Minecraft minecraft = Minecraft.m_91087_();
            ModelManager modelManager = minecraft.m_91304_();
            BakedModel model = minecraft.m_91291_().m_115103_().m_109394_((Item)TinkerModifiers.creativeSlotItem.get());
            if (model != null && (patt3953$temp = model.m_7343_()) instanceof NBTKeyModel.Overrides) {
                NBTKeyModel.Overrides overrides = (NBTKeyModel.Overrides)patt3953$temp;
                Material material = overrides.getTexture(slotType == null ? "slotless" : slotType.getName());
                return modelManager.m_119428_(material.m_119193_()).m_118316_(material.m_119203_());
            }
            return modelManager.m_119428_(InventoryMenu.f_39692_).m_118316_(MissingTextureAtlasSprite.m_118071_());
        };
    }
}

