/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.mapping.CompactLoadable;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolModel
implements IUnbakedGeometry<ToolModel> {
    public static final IGeometryLoader<ToolModel> LOADER = ToolModel::deserialize;
    private static final BitSet SMALL_TOOL_TYPES = new BitSet();
    public static final ItemColor COLOR_HANDLER = (stack, index) -> {
        ItemOverrides patt5626$temp;
        BakedModel itemModel;
        if (index >= 0 && (itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(stack.m_41720_())) != null && (patt5626$temp = itemModel.m_7343_()) instanceof MaterialOverrideHandler) {
            ModifierEntry entry;
            int i;
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)patt5626$temp;
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            ModifierEntry[] firsts = new ModifierEntry[overrides.firstModifiers.size()];
            for (i = modifiers.size() - 1; i >= 0; --i) {
                entry = modifiers.get(i);
                ModifierId id = entry.getId();
                int firstIndex = FirstModifier.indexOf(overrides.firstModifiers, id);
                if (firstIndex != -1) {
                    firsts[firstIndex] = entry;
                    continue;
                }
                IBakedModifierModel modifierModel = overrides.modifierModels.get((Object)entry.getId());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
            for (i = firsts.length - 1; i >= 0; --i) {
                IBakedModifierModel model;
                entry = firsts[i];
                FirstModifier first = overrides.firstModifiers.get(i);
                if (entry == null && !first.forced || (model = overrides.modifierModels.get((Object)first.id)) == null) continue;
                int modelIndexes = model.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return model.getTint(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY), index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private final List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vec2 offset;
    private final List<ResourceLocation> smallModifierRoots;
    private final List<ResourceLocation> largeModifierRoots;
    private final List<FirstModifier> firstModifiers;
    @Nullable
    private final ResourceLocation ammoKey;
    private final boolean flipAmmo;
    private final boolean leftAmmo;
    private final Vec2 smallAmmoOffset;
    private final Vec2 largeAmmoOffset;

    public static synchronized void registerSmallTool(ItemDisplayContext type) {
        SMALL_TOOL_TYPES.set(type.ordinal());
    }

    public static void registerItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.m_92689_(COLOR_HANDLER, new ItemLike[]{item.get()});
    }

    private static Vec2 getOffset(JsonObject parent, String key) {
        if (parent.has(key)) {
            return MaterialModel.getVec2(parent, key);
        }
        return Vec2.f_82462_;
    }

    public static ToolModel deserialize(JsonObject json, JsonDeserializationContext context) {
        List parts = Collections.emptyList();
        if (json.has("parts")) {
            parts = JsonHelper.parseList((JsonObject)json, (String)"parts", ToolPart::read);
        }
        boolean isLarge = GsonHelper.m_13855_((JsonObject)json, (String)"large", (boolean)false);
        Vec2 offset = ToolModel.getOffset(json, "large_offset");
        List smallModifierRoots = Collections.emptyList();
        List largeModifierRoots = Collections.emptyList();
        if (json.has("modifier_roots")) {
            if (isLarge) {
                JsonObject modifierRoots = GsonHelper.m_13930_((JsonObject)json, (String)"modifier_roots");
                BiFunction<JsonElement, String, ResourceLocation> parser = (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string));
                smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
            } else {
                smallModifierRoots = JsonHelper.parseList((JsonObject)json, (String)"modifier_roots", (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string)));
            }
        }
        ResourceLocation ammoKey = null;
        Vec2 smallAmmoOffset = Vec2.f_82462_;
        Vec2 largeAmmoOffset = Vec2.f_82462_;
        boolean flipAmmo = false;
        boolean leftAmmo = false;
        if (json.has("ammo")) {
            JsonObject ammo = GsonHelper.m_13930_((JsonObject)json, (String)"ammo");
            ammoKey = JsonHelper.getResourceLocation((JsonObject)ammo, (String)"key");
            flipAmmo = GsonHelper.m_13912_((JsonObject)ammo, (String)"flip");
            leftAmmo = GsonHelper.m_13912_((JsonObject)ammo, (String)"left");
            if (isLarge) {
                if (!ammo.has("small_offset") && !ammo.has("large_offset")) {
                    throw new JsonSyntaxException("Ammo must either have a small or large offset provided");
                }
                smallAmmoOffset = ToolModel.getOffset(ammo, "small_offset");
                largeAmmoOffset = ToolModel.getOffset(ammo, "large_offset");
            } else {
                smallAmmoOffset = MaterialModel.getVec2(ammo, "offset");
            }
        }
        List firstModifiers = (List)FirstModifier.LOADABLE.getOrDefault(json, "first_modifiers", List.of());
        return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers, ammoKey, flipAmmo, leftAmmo, smallAmmoOffset, largeAmmoOffset);
    }

    private static void addModifierQuads(Function<Material, TextureAtlasSprite> spriteGetter, Map<ModifierId, IBakedModifierModel> modifierModels, List<FirstModifier> firstModifiers, IToolStackView tool, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels, Transformation transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            ModifierEntry[] firsts = new ModifierEntry[firstModifiers.size()];
            if (!modifiers.isEmpty()) {
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                for (int i = modifiers.size() - 1; i >= 0; --i) {
                    IBakedModifierModel model;
                    ModifierEntry entry = modifiers.get(i);
                    ModifierId modifier = entry.getModifier().getId();
                    int index = FirstModifier.indexOf(firstModifiers, modifier);
                    if (index != -1) {
                        firsts[index] = entry;
                        continue;
                    }
                    if (hidden.contains((Object)modifier) || (model = modifierModels.get((Object)modifier)) == null) continue;
                    model.addQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, quadConsumer, pixels);
                    modelIndex += model.getTintIndexes();
                }
            }
            for (int i = firsts.length - 1; i >= 0; --i) {
                IBakedModifierModel model;
                ModifierEntry entry = firsts[i];
                FirstModifier first = firstModifiers.get(i);
                if (entry == null && !first.forced || (model = modifierModels.get((Object)first.id)) == null) continue;
                model.addQuads(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY), spriteGetter, transforms, isLarge, modelIndex, quadConsumer, pixels);
                modelIndex += model.getTintIndexes();
            }
        }
    }

    private static IModelBuilder<?> makeModelBuilder(IGeometryBakingContext context, ItemOverrides overrides, TextureAtlasSprite particle) {
        return IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)overrides, (TextureAtlasSprite)particle, (RenderTypeGroup)MantleItemLayerModel.getDefaultRenderType((IGeometryBakingContext)context));
    }

    private static BakedModel bakeInternal(IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, @Nullable Transformation largeTransforms, List<ToolPart> parts, Map<ModifierId, IBakedModifierModel> modifierModels, List<FirstModifier> firstModifiers, List<MaterialVariantId> materials, @Nullable IToolStackView tool, ItemOverrides overrides, Collection<BakedQuad> smallExtraQuads, Collection<BakedQuad> largeExtraQuads, Collection<BakedQuad> leftExtraQuads) {
        BakedModel left;
        BakedModel right;
        IModelBuilder<?> leftBuilder;
        ItemLayerPixels largePixels;
        Transformation smallTransforms = Transformation.m_121093_();
        ReversedListBuilder smallQuads = new ReversedListBuilder();
        ItemLayerPixels smallPixels = new ItemLayerPixels();
        ReversedListBuilder largeQuads = largeTransforms != null ? new ReversedListBuilder() : smallQuads;
        ItemLayerPixels itemLayerPixels = largePixels = largeTransforms != null ? new ItemLayerPixels() : smallPixels;
        if (tool != null && !modifierModels.isEmpty()) {
            ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, arg_0 -> ((ReversedListBuilder)smallQuads).add(arg_0), smallPixels, smallTransforms, false);
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, arg_0 -> ((ReversedListBuilder)largeQuads).add(arg_0), largePixels, largeTransforms, true);
            }
        }
        TextureAtlasSprite particle = null;
        for (int i = parts.size() - 1; i >= 0; --i) {
            ToolPart part = parts.get(i);
            if (part.hasMaterials()) {
                int index = part.index();
                MaterialVariantId material = index < materials.size() ? materials.get(index) : IMaterial.UNKNOWN_ID;
                MaterialRenderInfo.TintedSprite materialSprite = MaterialModel.getMaterialSprite(spriteGetter, owner.getMaterial(part.getName(false)), material);
                particle = materialSprite.sprite();
                smallQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)materialSprite.color(), (int)-1, (TextureAtlasSprite)materialSprite.sprite(), (Transformation)smallTransforms, (int)materialSprite.emissivity(), (ItemLayerPixels)smallPixels));
                if (largeTransforms == null) continue;
                largeQuads.add(MaterialModel.getQuadsForMaterial(spriteGetter, owner.getMaterial(part.getName(true)), material, -1, largeTransforms, largePixels));
                continue;
            }
            particle = spriteGetter.apply(owner.getMaterial(part.getName(false)));
            smallQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)0, (ItemLayerPixels)smallPixels));
            if (largeTransforms == null) continue;
            largeQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.getMaterial(part.getName(true))), (Transformation)largeTransforms, (int)0, (ItemLayerPixels)largePixels));
        }
        if (particle == null) {
            particle = spriteGetter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_()));
            TConstruct.LOG.error("Created tool model without a particle sprite, this means it somehow has no parts. This should not be possible");
        }
        IModelBuilder<?> smallBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        IModelBuilder<?> guiBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        IModelBuilder<?> iModelBuilder = leftBuilder = !leftExtraQuads.isEmpty() ? ToolModel.makeModelBuilder(owner, overrides, particle) : null;
        if (largeTransforms == null && leftBuilder != null) {
            smallQuads.build(quads -> quads.forEach(quad -> {
                smallBuilder.addUnculledFace(quad);
                leftBuilder.addUnculledFace(quad);
                if (quad.m_111306_() == Direction.SOUTH) {
                    guiBuilder.addUnculledFace(quad);
                }
            }));
        } else {
            smallQuads.build(quads -> quads.forEach(quad -> {
                smallBuilder.addUnculledFace(quad);
                if (quad.m_111306_() == Direction.SOUTH) {
                    guiBuilder.addUnculledFace(quad);
                }
            }));
        }
        for (BakedQuad quad : smallExtraQuads) {
            smallBuilder.addUnculledFace(quad);
            if (quad.m_111306_() != Direction.SOUTH) continue;
            guiBuilder.addUnculledFace(quad);
        }
        BakedModel small = smallBuilder.build();
        BakedModel gui = guiBuilder.build();
        if (largeTransforms != null) {
            IModelBuilder<?> largeBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
            if (leftBuilder != null) {
                largeQuads.build(quads -> quads.forEach(quad -> {
                    largeBuilder.addUnculledFace(quad);
                    leftBuilder.addUnculledFace(quad);
                }));
            } else {
                largeQuads.build(quads -> quads.forEach(arg_0 -> ((IModelBuilder)largeBuilder).addUnculledFace(arg_0)));
            }
            for (BakedQuad quad : largeExtraQuads) {
                largeBuilder.addUnculledFace(quad);
            }
            right = largeBuilder.build();
        } else {
            right = small;
        }
        if (leftBuilder != null) {
            for (BakedQuad quad : leftExtraQuads) {
                leftBuilder.addUnculledFace(quad);
            }
            left = leftBuilder.build();
        } else {
            left = right;
        }
        return new BakedToolModel(right, left, small, gui);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        List<ToolPart> toolParts = this.toolParts;
        if (toolParts.isEmpty()) {
            toolParts = ToolPart.DEFAULT_PARTS;
        }
        if (((Boolean)Config.CLIENT.logMissingMaterialTextures.get()).booleanValue()) {
            for (ToolPart part : toolParts) {
                if (!part.hasMaterials()) continue;
                MaterialModel.validateMaterialTextures(owner, spriteGetter, part.getName(false), null);
                if (!this.isLarge) continue;
                MaterialModel.validateMaterialTextures(owner, spriteGetter, part.getName(true), null);
            }
        }
        Map<ModifierId, IBakedModifierModel> modifierModels = ModifierModelManager.getModelsForTool(spriteGetter, this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList());
        Transformation largeTransforms = this.isLarge ? new Transformation(new Vector3f((this.offset.f_82470_ - 8.0f) / 32.0f, (-this.offset.f_82471_ - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        Transformation smallAmmoTransforms = null;
        Transformation largeAmmoTransforms = null;
        Transformation leftAmmoTransforms = null;
        if (this.ammoKey != null) {
            Quaternionf ammoRotation = this.flipAmmo ? Axis.f_252436_.m_252977_(-180.0f) : null;
            float flipOffset = this.flipAmmo ? 1.0f : 0.0f;
            Vector3f translation = new Vector3f(this.smallAmmoOffset.f_82470_ / 16.0f + flipOffset, -this.smallAmmoOffset.f_82471_ / 16.0f, 0.0625f + flipOffset);
            smallAmmoTransforms = new Transformation(translation, ammoRotation, null, null);
            if (this.isLarge) {
                translation = new Vector3f((this.offset.f_82470_ / 2.0f + this.largeAmmoOffset.f_82470_ + 4.0f) / 16.0f + flipOffset, (-this.offset.f_82471_ / 2.0f - this.largeAmmoOffset.f_82471_ + 4.0f) / 16.0f, 0.0625f + flipOffset);
                largeAmmoTransforms = new Transformation(translation, ammoRotation, null, null);
            }
            if (this.leftAmmo) {
                translation = new Vector3f((Vector3fc)translation);
                translation.z = -0.0625f + flipOffset;
                leftAmmoTransforms = new Transformation(translation, ammoRotation, null, null);
            }
        }
        overrides = new MaterialOverrideHandler(owner, toolParts, this.firstModifiers, largeTransforms, modifierModels, overrides, this.ammoKey, this.flipAmmo, smallAmmoTransforms, largeAmmoTransforms, leftAmmoTransforms);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, toolParts, modifierModels, this.firstModifiers, List.of(), null, overrides, List.of(), List.of(), List.of());
    }

    private ToolModel(List<ToolPart> toolParts, boolean isLarge, Vec2 offset, List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, List<FirstModifier> firstModifiers, @Nullable ResourceLocation ammoKey, boolean flipAmmo, boolean leftAmmo, Vec2 smallAmmoOffset, Vec2 largeAmmoOffset) {
        this.toolParts = toolParts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
        this.ammoKey = ammoKey;
        this.flipAmmo = flipAmmo;
        this.leftAmmo = leftAmmo;
        this.smallAmmoOffset = smallAmmoOffset;
        this.largeAmmoOffset = largeAmmoOffset;
    }

    private record FirstModifier(ModifierId id, boolean forced) {
        private static final Loadable<List<FirstModifier>> LOADABLE = CompactLoadable.of((RecordLoadable)RecordLoadable.create((RecordField)ModifierId.PARSER.requiredField("name", FirstModifier::id), (RecordField)BooleanLoadable.INSTANCE.defaultField("forced", (Object)false, false, FirstModifier::forced), FirstModifier::new), (Loadable)ModifierId.PARSER.flatXmap(id -> new FirstModifier((ModifierId)((Object)id), false), FirstModifier::id), f -> !f.forced).list(0);

        public static int indexOf(List<FirstModifier> list, ModifierId id) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get((int)i).id.equals((Object)id)) continue;
                return i;
            }
            return -1;
        }
    }

    private record ToolPart(String name, int index) {
        public static final ToolPart DEFAULT = new ToolPart("tool", -1);
        public static final List<ToolPart> DEFAULT_PARTS = List.of(DEFAULT);

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isLarge) {
            if (isLarge) {
                return "large_" + this.name;
            }
            return this.name;
        }

        public static ToolPart read(JsonObject json) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)-1);
            return new ToolPart(name, index);
        }
    }

    private static class BakedToolModel
    extends BakedModelWrapper<BakedModel> {
        private final BakedModel left;
        private final BakedModel small;
        private final BakedModel gui;

        public BakedToolModel(BakedModel right, BakedModel left, BakedModel small, BakedModel gui) {
            super(right);
            this.left = left;
            this.small = small;
            this.gui = gui;
        }

        public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack mat, boolean applyLeftHandTransform) {
            BakedModel model = this.originalModel;
            if (cameraTransformType == ItemDisplayContext.GUI) {
                model = this.gui;
            } else if (cameraTransformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                model = this.left;
                model = this.left;
            } else if (this.originalModel != this.small && SMALL_TOOL_TYPES.get(cameraTransformType.ordinal())) {
                model = this.small;
            }
            return model.applyTransform(cameraTransformType, mat, applyLeftHandTransform);
        }
    }

    public static final class MaterialOverrideHandler
    extends ItemOverrides {
        private static boolean ignoreNested = false;
        private final Cache<ToolCacheKey, BakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final IGeometryBakingContext owner;
        private final List<ToolPart> toolParts;
        private final List<FirstModifier> firstModifiers;
        @Nullable
        private final Transformation largeTransforms;
        private final Map<ModifierId, IBakedModifierModel> modifierModels;
        private final ItemOverrides nested;
        @Nullable
        private final ResourceLocation ammoKey;
        private final boolean flipAmmo;
        @Nullable
        private final Transformation smallAmmoTransforms;
        @Nullable
        private final Transformation largeAmmoTransforms;
        @Nullable
        private final Transformation leftAmmoTransforms;

        private BakedModel bakeDynamic(List<MaterialVariantId> materials, IToolStackView tool, ItemStack ammo, int seed) {
            BakedModel ammoModel;
            List smallAmmoQuads = List.of();
            List largeAmmoQuads = List.of();
            List leftAmmoQuads = List.of();
            if (!ammo.m_41619_() && (ammoModel = Minecraft.m_91087_().m_91291_().m_174264_(ammo, null, null, seed)) != Minecraft.m_91087_().m_91304_().m_119409_() && (ammoModel = ammoModel.m_7343_().m_173464_(ammoModel, ammo, null, null, seed)) != null) {
                List<Object> ammoQuads = new ArrayList();
                RandomSource rand = RandomSource.m_216327_();
                for (Direction direction : Direction.values()) {
                    ammoQuads.addAll(ammoModel.getQuads(null, direction, rand, ModelData.EMPTY, null));
                }
                ammoQuads.addAll(ammoModel.getQuads(null, null, rand, ModelData.EMPTY, null));
                Int2IntArrayMap tints = new Int2IntArrayMap();
                ItemColors colors = Minecraft.m_91087_().getItemColors();
                Int2IntFunction colorGetter = tint -> ColoredBlockModel.swapColorRedBlue((int)colors.m_92676_(ammo, tint));
                ammoQuads = ammoQuads.stream().map(arg_0 -> this.lambda$bakeDynamic$1((Int2IntMap)tints, colorGetter, arg_0)).toList();
                if (this.smallAmmoTransforms != null) {
                    smallAmmoQuads = QuadTransformers.applying((Transformation)this.smallAmmoTransforms).process(ammoQuads);
                }
                if (this.largeAmmoTransforms != null) {
                    largeAmmoQuads = QuadTransformers.applying((Transformation)this.largeAmmoTransforms).process(ammoQuads);
                }
                if (this.leftAmmoTransforms != null) {
                    leftAmmoQuads = QuadTransformers.applying((Transformation)this.leftAmmoTransforms).process(ammoQuads);
                }
            }
            return ToolModel.bakeInternal(this.owner, Material::m_119204_, this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, ItemOverrides.f_111734_, smallAmmoQuads, largeAmmoQuads, leftAmmoQuads);
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            ItemStack ammo;
            ToolStack tool;
            List<MaterialVariantId> materialIds;
            block11: {
                BakedModel overridden;
                if (!ignoreNested && (overridden = this.nested.m_173464_(originalModel, stack, world, entity, seed)) != null && overridden != originalModel) {
                    ignoreNested = true;
                    BakedModel finalModel = overridden.m_7343_().m_173464_(overridden, stack, world, entity, seed);
                    ignoreNested = false;
                    return finalModel;
                }
                materialIds = MaterialIdNBT.from(stack).getMaterials();
                tool = ToolStack.from(stack);
                if (materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                    for (FirstModifier modifier : this.firstModifiers) {
                        if (!modifier.forced) continue;
                        break block11;
                    }
                    return originalModel;
                }
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
            ModifierEntry[] firstEntries = new ModifierEntry[this.firstModifiers.size()];
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model;
                ModifierId id = entry.getId();
                int index = FirstModifier.indexOf(this.firstModifiers, id);
                if (index != -1) {
                    firstEntries[index] = entry;
                    continue;
                }
                if (hidden.contains((Object)id) || (model = this.modifierModels.get((Object)id)) == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            for (int i = 0; i < this.firstModifiers.size(); ++i) {
                Object cacheKey;
                IBakedModifierModel model;
                FirstModifier modifier = this.firstModifiers.get(i);
                ModifierEntry entry = firstEntries[i];
                if (entry == null && !modifier.forced || (model = this.modifierModels.get((Object)modifier.id)) == null || (cacheKey = model.getCacheKey(tool, Objects.requireNonNullElse(entry, ModifierEntry.EMPTY))) == null) continue;
                builder.add(cacheKey);
            }
            ModDataNBT persistentData = tool.getPersistentData();
            if (this.ammoKey != null && persistentData.contains(this.ammoKey, 10)) {
                ammo = ItemStack.m_41712_((CompoundTag)persistentData.getCompound(this.ammoKey));
                builder.add((Object)ammo.m_41720_());
                CompoundTag tag = ammo.m_41783_();
                if (tag != null) {
                    builder.add((Object)tag);
                }
            } else {
                ammo = ItemStack.f_41583_;
            }
            try {
                return (BakedModel)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build()), () -> this.bakeDynamic(materialIds, tool, ammo, seed));
            }
            catch (ExecutionException e) {
                TConstruct.LOG.error("Failed to get tool model from cache", (Throwable)e);
                return originalModel;
            }
        }

        private MaterialOverrideHandler(IGeometryBakingContext owner, List<ToolPart> toolParts, List<FirstModifier> firstModifiers, @Nullable Transformation largeTransforms, Map<ModifierId, IBakedModifierModel> modifierModels, ItemOverrides nested, @Nullable ResourceLocation ammoKey, boolean flipAmmo, @Nullable Transformation smallAmmoTransforms, @Nullable Transformation largeAmmoTransforms, @Nullable Transformation leftAmmoTransforms) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
            this.nested = nested;
            this.ammoKey = ammoKey;
            this.flipAmmo = flipAmmo;
            this.smallAmmoTransforms = smallAmmoTransforms;
            this.largeAmmoTransforms = largeAmmoTransforms;
            this.leftAmmoTransforms = leftAmmoTransforms;
        }

        private /* synthetic */ BakedQuad lambda$bakeDynamic$1(Int2IntMap tints, Int2IntFunction colorGetter, BakedQuad quad) {
            if (quad.m_111304_() || this.flipAmmo && quad.m_111306_().m_122434_() != Direction.Axis.Y) {
                int[] vertices = quad.m_111303_();
                if (quad.m_111304_()) {
                    int abgr = 0xFF000000 | tints.computeIfAbsent(quad.m_111305_(), colorGetter);
                    vertices = Arrays.copyOf(vertices, vertices.length);
                    for (int i = 0; i < 4; ++i) {
                        vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.COLOR] = abgr;
                    }
                }
                Direction direction = quad.m_111306_();
                if (this.flipAmmo && direction.m_122434_() != Direction.Axis.Y) {
                    direction = direction.m_122424_();
                }
                return new BakedQuad(vertices, -1, direction, quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion());
            }
            return quad;
        }
    }

    private record ToolCacheKey(List<MaterialVariantId> materials, List<Object> modifierData) {
    }
}

