/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.block.TankModel;

public class FluidTextureModel
implements IUnbakedGeometry<FluidTextureModel> {
    public static final IGeometryLoader<FluidTextureModel> LOADER = FluidTextureModel::deserialize;
    private final ColoredBlockModel model;
    private final Set<String> fluids;
    private final Set<String> retextured;

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.model.resolveParents(modelGetter, context);
    }

    private static String trimTextureName(String name) {
        if (name.charAt(0) == '#') {
            return name.substring(1);
        }
        return name;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel baked = this.model.bake(owner, baker, spriteGetter, transform, overrides, modelLocation);
        Set fluidTextures = this.fluids.isEmpty() ? Collections.emptySet() : RetexturedModel.getAllRetextured((IGeometryBakingContext)owner, (SimpleBlockModel)this.model, this.fluids);
        List elements = this.model.getElements();
        int size = elements.size();
        BitSet fluidParts = new BitSet(size);
        if (!fluidTextures.isEmpty()) {
            for (int i = 0; i < size; ++i) {
                BlockElement part = (BlockElement)elements.get(i);
                long fluidFaces = part.f_111310_.values().stream().filter(face -> fluidTextures.contains(FluidTextureModel.trimTextureName(face.f_111356_))).count();
                if (fluidFaces <= 0L) continue;
                if (fluidFaces < (long)part.f_111310_.size()) {
                    TConstruct.LOG.warn("Mixed fluid and non-fluid elements in model {}, may cause unexpected results", (Object)modelLocation);
                }
                fluidParts.set(i);
            }
        }
        Set retextured = this.retextured.isEmpty() ? Collections.emptySet() : RetexturedModel.getAllRetextured((IGeometryBakingContext)owner, (SimpleBlockModel)this.model, this.retextured);
        return new Baked(baked, elements, this.model.getColorData(), owner, transform, fluidTextures, fluidParts, retextured);
    }

    public static FluidTextureModel deserialize(JsonObject json, JsonDeserializationContext context) {
        ColoredBlockModel model = ColoredBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        ImmutableSet fluids = Collections.emptySet();
        if (json.has("fluids")) {
            fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", GsonHelper::m_13805_));
        }
        ImmutableSet retextured = Collections.emptySet();
        if (json.has("retextured")) {
            retextured = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"retextured", GsonHelper::m_13805_));
        }
        return new FluidTextureModel(model, (Set<String>)fluids, (Set<String>)retextured);
    }

    public FluidTextureModel(ColoredBlockModel model, Set<String> fluids, Set<String> retextured) {
        this.model = model;
        this.fluids = fluids;
        this.retextured = retextured;
    }

    private static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final Map<BakedCacheKey, BakedModel> cache = new ConcurrentHashMap<BakedCacheKey, BakedModel>();
        private final List<BlockElement> elements;
        private final List<ColoredBlockModel.ColorData> colorData;
        private final IGeometryBakingContext owner;
        private final ModelState transform;
        private final Set<String> fluids;
        private final BitSet fluidParts;
        private final Set<String> retextured;
        private final ItemOverrides overrides = new RetexturedOverride();

        protected Baked(BakedModel originalModel, List<BlockElement> elements, List<ColoredBlockModel.ColorData> colorData, IGeometryBakingContext owner, ModelState transform, Set<String> fluids, BitSet fluidParts, Set<String> retextured) {
            super(originalModel);
            this.elements = elements;
            this.colorData = colorData;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
            this.fluidParts = fluidParts;
            this.retextured = retextured;
        }

        private BakedModel getRetexturedModel(BakedCacheKey key) {
            IQuadTransformer quadTransformer;
            Function<Material, TextureAtlasSprite> spriteGetter = Material::m_119204_;
            IGeometryBakingContext textured = this.owner;
            if (key.texture != null) {
                textured = new RetexturedModel.RetexturedContext(textured, this.retextured, key.texture);
            }
            IQuadTransformer fluidTransformer = quadTransformer = SimpleBlockModel.applyTransform((ModelState)this.transform, (Transformation)this.owner.getRootTransform());
            int luminosity = 0;
            if (!key.fluid.isEmpty()) {
                IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)key.fluid.getFluid());
                int color = attributes.getTintColor(key.fluid);
                if (color != -1) {
                    fluidTransformer = ColoredBlockModel.applyColorQuadTransformer((int)color).andThen(quadTransformer);
                }
                luminosity = key.fluid.getFluid().getFluidType().getLightLevel(key.fluid);
                textured = new RetexturedModel.RetexturedContext(textured, this.fluids, attributes.getStillTexture(key.fluid));
            }
            TextureAtlasSprite particle = spriteGetter.apply(textured.getMaterial("particle"));
            SimpleBakedModel.Builder builder = SimpleBlockModel.bakedBuilder((IGeometryBakingContext)this.owner, (ItemOverrides)ItemOverrides.f_111734_).m_119528_(particle);
            boolean defaultUvLock = this.transform.m_7538_();
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                BlockElement element = this.elements.get(i);
                ColoredBlockModel.ColorData colors = (ColoredBlockModel.ColorData)LogicHelper.getOrDefault(this.colorData, (int)i, (Object)ColoredBlockModel.ColorData.DEFAULT);
                if (this.fluidParts.get(i)) {
                    ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)textured, (BlockElement)element, (int)luminosity, spriteGetter, (Transformation)this.transform.m_6189_(), (IQuadTransformer)fluidTransformer, (boolean)colors.isUvLock(defaultUvLock), (ResourceLocation)TankModel.BAKE_LOCATION);
                    continue;
                }
                int partColor = colors.color();
                IQuadTransformer partTransformer = partColor == -1 ? quadTransformer : ColoredBlockModel.applyColorQuadTransformer((int)partColor).andThen(quadTransformer);
                ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)textured, (BlockElement)element, (int)colors.luminosity(), spriteGetter, (Transformation)this.transform.m_6189_(), (IQuadTransformer)partTransformer, (boolean)colors.isUvLock(defaultUvLock), (ResourceLocation)TankModel.BAKE_LOCATION);
            }
            return builder.build(SimpleBlockModel.getRenderTypeGroup((IGeometryBakingContext)this.owner));
        }

        private BakedModel getCachedModel(BakedCacheKey key) {
            return this.cache.computeIfAbsent(key, this::getRetexturedModel);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData data, @Nullable RenderType renderType) {
            Block block;
            FluidStack fluid;
            FluidStack fluidStack = fluid = this.fluids.isEmpty() ? FluidStack.EMPTY : (FluidStack)data.get(ModelProperties.FLUID_STACK);
            if (fluid == null) {
                fluid = FluidStack.EMPTY;
            }
            Block block2 = block = this.retextured.isEmpty() ? null : (Block)data.get(RetexturedHelper.BLOCK_PROPERTY);
            if (!fluid.isEmpty() || block != null) {
                BakedCacheKey key = new BakedCacheKey(fluid, block != null ? ModelHelper.getParticleTexture((Block)block) : null);
                return this.getCachedModel(key).getQuads(state, direction, random, data, renderType);
            }
            return this.originalModel.getQuads(state, direction, random, data, renderType);
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        private class RetexturedOverride
        extends ItemOverrides {
            private RetexturedOverride() {
            }

            @Nullable
            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int pSeed) {
                if (stack.m_41619_() || !stack.m_41782_()) {
                    return originalModel;
                }
                Block block = RetexturedHelper.getTexture((ItemStack)stack);
                if (block == Blocks.f_50016_) {
                    return originalModel;
                }
                return Baked.this.getCachedModel(new BakedCacheKey(FluidStack.EMPTY, ModelHelper.getParticleTexture((Block)block)));
            }
        }
    }

    private record BakedCacheKey(FluidStack fluid, @Nullable ResourceLocation texture) {
    }
}

