/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.module;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.BasicModifier;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.WithHooks;

public class ModuleHookMap {
    public static final ModuleHookMap EMPTY = new ModuleHookMap(Collections.emptyMap());
    private final Map<ModuleHook<?>, Object> modules;

    public static ModuleHookMap createMap(List<? extends WithHooks<?>> modules, ErrorFactory error) {
        if (modules.isEmpty()) {
            return EMPTY;
        }
        Builder builder = ModuleHookMap.builder();
        for (WithHooks<?> withHooks : modules) {
            Object module = withHooks.module();
            for (ModuleHook<?> hook : withHooks.getModuleHooks()) {
                builder.addHookChecked(module, hook, error);
            }
            module.addModules(builder);
        }
        return builder.build();
    }

    public boolean hasHook(ModuleHook<?> hook) {
        return this.modules.containsKey(hook);
    }

    @Nullable
    public <T> T getOrNull(ModuleHook<T> hook) {
        return (T)this.modules.get(hook);
    }

    public <T> T getOrDefault(ModuleHook<T> hook) {
        T object = this.getOrNull(hook);
        if (object != null) {
            return object;
        }
        return hook.getDefaultInstance();
    }

    public Map<ModuleHook<?>, Object> getAllModules() {
        return this.modules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ModuleHookMap(Map<ModuleHook<?>, Object> modules) {
        this.modules = modules;
    }

    public static class Builder {
        private final ErrorFactory ILLEGAL_ARGUMENT = IllegalArgumentException::new;
        private final LinkedHashMultimap<ModuleHook<?>, Object> modules = LinkedHashMultimap.create();

        private Builder() {
        }

        public Builder addHookChecked(Object object, ModuleHook<?> hook) {
            return this.addHookChecked(object, hook, this.ILLEGAL_ARGUMENT);
        }

        public Builder addHookChecked(Object object, ModuleHook<?> hook, ErrorFactory error) {
            if (!hook.isValid(object)) {
                throw error.create("Object " + object + " is invalid for hook " + hook);
            }
            this.modules.put(hook, object);
            return this;
        }

        public Builder addModule(HookProvider module) {
            for (ModuleHook<?> hook : module.getDefaultHooks()) {
                this.addHookChecked(module, hook);
            }
            module.addModules(this);
            return this;
        }

        public <H, T extends H> Builder addHook(T object, ModuleHook<H> hook) {
            this.modules.put(hook, object);
            return this;
        }

        public <T> Builder addHook(T object, ModuleHook<? super T> hook1, ModuleHook<? super T> hook2) {
            this.addHook(object, (ModuleHook)hook1);
            this.addHook(object, (ModuleHook)hook2);
            return this;
        }

        public <T> Builder addHook(T object, ModuleHook<? super T> hook1, ModuleHook<? super T> hook2, ModuleHook<? super T> hook3) {
            this.addHook(object, (ModuleHook)hook1);
            this.addHook(object, (ModuleHook)hook2);
            this.addHook(object, (ModuleHook)hook3);
            return this;
        }

        @SafeVarargs
        public final <T> Builder addHook(T object, ModuleHook<? super T> ... hooks) {
            if (hooks.length == 0) {
                TConstruct.LOG.error("Module {} added with no hooks, this is a bug in the mod adding it as it does nothing, and will not be allowed in the future.", object, (Object)new IllegalArgumentException("Empty hooks list passed to hook map builder"));
            }
            for (ModuleHook<? super T> hook : hooks) {
                this.addHook(object, (ModuleHook)hook);
            }
            return this;
        }

        private static <T> void insert(ImmutableMap.Builder<ModuleHook<?>, Object> builder, ModuleHook<T> hook, Collection<Object> objects) {
            if (objects.size() == 1) {
                builder.put(hook, objects.iterator().next());
            } else if (!objects.isEmpty()) {
                builder.put(hook, hook.merge(objects));
            }
        }

        public ModuleHookMap build() {
            if (this.modules.isEmpty()) {
                return EMPTY;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.modules.asMap().entrySet()) {
                Builder.insert(builder, (ModuleHook)entry.getKey(), (Collection)entry.getValue());
            }
            return new ModuleHookMap((Map<ModuleHook<?>, Object>)builder.build());
        }

        public BasicModifier.Builder modifier() {
            return BasicModifier.Builder.builder(this.build());
        }
    }
}

