/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.menu.module;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import slimeknights.mantle.inventory.BaseContainerMenu;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;

public class SideInventoryContainer<TILE extends BlockEntity>
extends BaseContainerMenu<TILE> {
    private final int columns;
    private final int slotCount;
    protected final LazyOptional<IItemHandler> itemHandler;

    public SideInventoryContainer(MenuType<?> containerType, int windowId, Inventory inv, @Nullable TILE tile, int x, int y, int columns) {
        this(containerType, windowId, inv, tile, null, x, y, columns);
    }

    public SideInventoryContainer(MenuType<?> containerType, int windowId, Inventory inv, @Nullable TILE tile, @Nullable Direction inventoryDirection, int x, int y, int columns) {
        super(containerType, windowId, inv, tile);
        this.itemHandler = tile == null ? LazyOptional.of(() -> EmptyHandler.INSTANCE) : tile.getCapability(ForgeCapabilities.ITEM_HANDLER, inventoryDirection);
        IItemHandler handler = (IItemHandler)this.itemHandler.orElse((Object)EmptyHandler.INSTANCE);
        this.slotCount = handler.getSlots();
        this.columns = columns;
        int rows = this.slotCount / columns;
        if (this.slotCount % columns != 0) {
            ++rows;
        }
        int index = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns && index < this.slotCount; ++index, ++c) {
                this.m_38897_(this.createSlot(handler, index, x + c * 18, y + r * 18));
            }
        }
    }

    protected Slot createSlot(IItemHandler itemHandler, int index, int x, int y) {
        return new SmartItemHandlerSlot(itemHandler, index, x, y);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

