/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.tank.ProxyItemTank;

public class ProxyTankBlockEntity
extends MantleBlockEntity
implements IFluidTankUpdater {
    private final ProxyItemTank<ProxyTankBlockEntity> itemTank = new ProxyItemTank<ProxyTankBlockEntity>(this);
    private final LazyOptional<ProxyItemTank<?>> capability = LazyOptional.of(() -> this.itemTank);
    private int lastStrength = -1;
    private static final String TAG_ITEM = "item";

    protected ProxyTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ProxyTankBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.proxyTank.get(), pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER || cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    private int calculateComparatorStrength() {
        int capacity = this.itemTank.getTankCapacity(0);
        if (capacity == 0) {
            return 0;
        }
        return 1 + 14 * this.itemTank.getFluidInTank(0).getAmount() / capacity;
    }

    public int getComparatorStrength() {
        if (this.lastStrength == -1) {
            this.lastStrength = this.calculateComparatorStrength();
        }
        return this.lastStrength;
    }

    @Override
    public void onTankContentsChanged() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.setChangedFast();
            int newStrength = this.calculateComparatorStrength();
            if (newStrength != this.lastStrength) {
                this.lastStrength = newStrength;
                this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            }
        }
    }

    public void interact(Player player, InteractionHand hand, boolean clickedTank) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ItemStack held = player.m_21120_(hand);
        ItemStack inventory = this.itemTank.getStack();
        if (!inventory.m_41619_()) {
            if (!held.m_41619_() && FluidTransferHelper.interactWithContainer((Level)this.f_58857_, (BlockPos)this.f_58858_, this.itemTank, (Player)player, (InteractionHand)hand).didTransfer() || FluidTransferHelper.interactWithFilledBucket((Level)this.f_58857_, (BlockPos)this.f_58858_, this.itemTank, (Player)player, (InteractionHand)hand, (Direction)((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_))).didTransfer()) {
                return;
            }
            if (clickedTank) {
                return;
            }
        }
        if (inventory.m_41619_()) {
            if (!held.m_41619_() && this.itemTank.isItemValid(0, held)) {
                ItemStack stack = held.m_41620_(this.itemTank.getSlotLimit(0));
                player.m_21008_(hand, held.m_41619_() ? ItemStack.f_41583_ : held);
                this.itemTank.setStack(stack);
            }
        } else if (held.m_41619_()) {
            player.m_21008_(hand, inventory);
            this.itemTank.setStack(ItemStack.f_41583_);
        } else {
            player.m_36356_(inventory);
            this.itemTank.setStack(inventory);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(TAG_ITEM, 10)) {
            this.itemTank.readFromNBT(tag.m_128469_(TAG_ITEM));
        }
    }

    protected void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        tag.m_128365_(TAG_ITEM, (Tag)this.itemTank.writeToNBT());
    }

    public ProxyItemTank<ProxyTankBlockEntity> getItemTank() {
        return this.itemTank;
    }
}

