/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifier
extends DurabilityShieldModifier
implements ToolStatsModifierHook {
    public static final FloatToolStat OVERSLIME_STAT = ToolStats.register(new FloatToolStat(new ToolStatId("tconstruct", "overslime"), -9315195, 0.0f, 0.0f, 32767.0f, (TagKey)TinkerTags.Items.DURABILITY){

        @Override
        public Float build(ModifierStatsBuilder parent, Object builderObj) {
            return Float.valueOf(super.build(parent, builderObj).floatValue() * parent.getMultiplier(ToolStats.DURABILITY));
        }
    });

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.TOOL_STATS);
    }

    @Override
    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        OVERSLIME_STAT.add(builder, 50.0);
        if (!context.getModifiers().has(TinkerTags.Modifiers.OVERSLIME_FRIEND)) {
            if (context.hasTag(TinkerTags.Items.MELEE)) {
                ToolStats.ATTACK_DAMAGE.multiply(builder, 0.9f);
            }
            if (context.hasTag(TinkerTags.Items.HARVEST)) {
                ToolStats.MINING_SPEED.multiply(builder, 0.9f);
            }
            if (context.hasTag(TinkerTags.Items.ARMOR)) {
                ToolStats.ARMOR.add(builder, -0.5);
            }
            if (context.hasTag(TinkerTags.Items.RANGED)) {
                ToolStats.VELOCITY.multiply(builder, 0.9f);
            }
        }
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return this.getShield(tool) < this.getShieldCapacity(tool, modifier) ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        if (this.getShield(tool) > 0) {
            return 53503;
        }
        return -1;
    }

    @Override
    public int getShieldCapacity(IToolStackView tool, ModifierEntry modifier) {
        return tool.getStats().getInt(OVERSLIME_STAT);
    }

    public static int getOverworkedBonus(IToolStackView tool) {
        return 1 + tool.getModifierLevel(TinkerModifiers.overworked.getId());
    }

    public void addOverslime(IToolStackView tool, ModifierEntry entry, int amount) {
        this.addShield(tool, entry, amount * OverslimeModifier.getOverworkedBonus(tool));
    }
}

