/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.menu;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.SimpleFluidTank;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.menu.ReadOnlySlot;
import slimeknights.tconstruct.tools.network.ToolContainerFluidUpdatePacket;

public class ToolContainerMenu
extends AbstractContainerMenu {
    public static final int SLOT_SIZE = 18;
    public static final int TITLE_SIZE = 13;
    public static final int UI_START = 4;
    public static final int REPEAT_BACKGROUND_START = 17;
    private final ItemStack stack;
    private final IToolStackView tool;
    private final IItemHandler itemHandler;
    private final SimpleFluidTank tank;
    private final Player player;
    private final int slotIndex;
    private final boolean showOffhand;
    @Nullable
    private final CraftingContainer craftingContainer;
    @Nullable
    private final ResultContainer resultContainer;
    private final int toolInventoryStart;
    private final int playerInventoryStart;

    public ToolContainerMenu(int id, Inventory playerInventory, ItemStack stack, IItemHandler itemHandler, int slotIndex) {
        this((MenuType)TinkerTools.toolContainer.get(), id, playerInventory, stack, itemHandler, slotIndex);
    }

    public static ToolContainerMenu forClient(int id, Inventory inventory, FriendlyByteBuf buffer) {
        int slotIndex = buffer.m_130242_();
        ItemStack stack = inventory.f_35978_.m_150109_().m_8020_(slotIndex);
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(EmptyItemHandler.INSTANCE);
        return new ToolContainerMenu((MenuType)TinkerTools.toolContainer.get(), id, inventory, stack, handler, slotIndex);
    }

    protected ToolContainerMenu(@Nullable MenuType<?> type, int id, Inventory playerInventory, ItemStack stack, IItemHandler handler, int slotIndex) {
        super(type, id);
        int c;
        this.stack = stack;
        this.tool = ToolStack.from(stack);
        this.itemHandler = handler;
        this.player = playerInventory.f_35978_;
        this.tank = new ToolFluidHandler(this.tool, this.player.m_9236_().f_46443_ ? null : this.player);
        this.slotIndex = slotIndex;
        int slots = this.itemHandler.getSlots();
        int craftingOffset = (slots == 0 ? 17 : 4) + 1;
        if (ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.CRAFTING_TABLE)) {
            this.craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
            this.resultContainer = new ResultContainer();
            this.m_38897_((Slot)new ResultSlot(this.player, this.craftingContainer, (Container)this.resultContainer, 0, 124, craftingOffset + 18));
            for (r = 0; r < 3; ++r) {
                for (c = 0; c < 3; ++c) {
                    this.m_38897_(new Slot((Container)this.craftingContainer, c + r * 3, 30 + c * 18, craftingOffset + r * 18));
                }
            }
        } else if (ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.INVENTORY_CRAFTING)) {
            this.craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
            this.resultContainer = new ResultContainer();
            this.m_38897_((Slot)new ResultSlot(this.player, this.craftingContainer, (Container)this.resultContainer, 0, 108, craftingOffset + 10));
            for (r = 0; r < 2; ++r) {
                for (c = 0; c < 2; ++c) {
                    this.m_38897_(new Slot((Container)this.craftingContainer, c + r * 2, 52 + c * 18, craftingOffset + r * 18));
                }
            }
        } else {
            this.craftingContainer = null;
            this.resultContainer = null;
        }
        this.toolInventoryStart = this.f_38839_.size();
        int yOffset = 17 + this.getCraftingHeight() * 18 + 1;
        for (int i = 0; i < slots; ++i) {
            this.m_38897_((Slot)new ToolContainerSlot(this.itemHandler, i, 8 + i % 9 * 18, yOffset + i / 9 * 18));
        }
        this.showOffhand = ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.INCLUDE_OFFHAND);
        if (this.showOffhand) {
            int x = 8 + slots % 9 * 18;
            int y = yOffset + slots / 9 * 18;
            if (slotIndex == 40) {
                this.m_38897_(new ReadOnlySlot((Container)playerInventory, 40, x, y));
            } else {
                this.m_38897_(new Slot((Container)playerInventory, 40, x, y));
            }
            ++slots;
        }
        this.playerInventoryStart = this.f_38839_.size();
        yOffset += 13 + (slots + 8) / 9 * 18;
        if (this.tank.getCapacity() > 0) {
            yOffset += 14;
        }
        for (int r = 0; r < 3; ++r) {
            for (int c2 = 0; c2 < 9; ++c2) {
                int index = c2 + r * 9 + 9;
                if (index == slotIndex) {
                    this.m_38897_(new ReadOnlySlot((Container)playerInventory, index, 8 + c2 * 18, yOffset + r * 18));
                    continue;
                }
                this.m_38897_(new Slot((Container)playerInventory, index, 8 + c2 * 18, yOffset + r * 18));
            }
        }
        yOffset += 58;
        for (c = 0; c < 9; ++c) {
            if (c == slotIndex) {
                this.m_38897_(new ReadOnlySlot((Container)playerInventory, c, 8 + c * 18, yOffset));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, c, 8 + c * 18, yOffset));
        }
    }

    public int getCraftingHeight() {
        return this.craftingContainer != null ? this.craftingContainer.m_39346_() : 0;
    }

    public boolean m_6875_(Player playerIn) {
        return this.player == playerIn && !this.stack.m_41619_() && this.player.m_150109_().m_8020_(this.slotIndex) == this.stack;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            int end = this.f_38839_.size();
            if (index < this.toolInventoryStart) {
                if (!this.m_38903_(slotStack, this.toolInventoryStart, end, true)) {
                    return ItemStack.f_41583_;
                }
                if (index == 0) {
                    slot.m_40234_(slotStack, result);
                }
            } else if (index < this.playerInventoryStart ? !this.m_38903_(slotStack, this.playerInventoryStart, end, true) : !this.m_38903_(slotStack, this.toolInventoryStart, this.playerInventoryStart, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(this.player, slotStack);
            if (this.toolInventoryStart > 0 && index == 0) {
                this.player.m_36176_(slotStack, false);
            }
        }
        return result;
    }

    public void m_6199_(Container pContainer) {
        super.m_6199_(pContainer);
        if (this.craftingContainer != null && this.resultContainer != null) {
            CraftingMenu.m_150546_((AbstractContainerMenu)this, (Level)this.player.m_9236_(), (Player)this.player, (CraftingContainer)this.craftingContainer, (ResultContainer)this.resultContainer);
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        if (this.resultContainer != null) {
            this.resultContainer.m_6211_();
        }
        if (this.craftingContainer != null) {
            this.m_150411_(pPlayer, (Container)this.craftingContainer);
        }
    }

    public boolean m_6366_(Player player, int id) {
        ItemStack held = this.m_142621_();
        if (!(id != 0 && id != 1 || held.m_41619_() || player.m_5833_())) {
            if (!player.m_9236_().f_46443_) {
                IFluidContainerTransfer.TransferResult result = FluidTransferHelper.interactWithStack((IFluidHandler)this.tank, (ItemStack)held, (IFluidContainerTransfer.TransferDirection)(id == 0 ? IFluidContainerTransfer.TransferDirection.FILL_ITEM : IFluidContainerTransfer.TransferDirection.EMPTY_ITEM));
                this.m_142503_(FluidTransferHelper.handleUIResult((Player)player, (ItemStack)held, (IFluidContainerTransfer.TransferResult)result));
            }
            return true;
        }
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IToolStackView getTool() {
        return this.tool;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public SimpleFluidTank getTank() {
        return this.tank;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public boolean isShowOffhand() {
        return this.showOffhand;
    }

    public int getToolInventoryStart() {
        return this.toolInventoryStart;
    }

    public int getPlayerInventoryStart() {
        return this.playerInventoryStart;
    }

    private record ToolFluidHandler(IToolStackView tool, @Nullable Player player) implements SimpleFluidTank
    {
        @Nonnull
        public FluidStack getFluid() {
            return ToolTankHelper.TANK_HELPER.getFluid(this.tool);
        }

        @Override
        public void setFluid(FluidStack fluid) {
            ToolTankHelper.TANK_HELPER.setFluid(this.tool, fluid);
        }

        @Override
        public void updateFluid(FluidStack updated, int change) {
            if (change != 0) {
                this.setFluid(updated);
                if (this.player != null) {
                    TinkerNetwork.getInstance().sendTo(new ToolContainerFluidUpdatePacket(updated), this.player);
                }
            }
        }

        public int getCapacity() {
            return ToolTankHelper.TANK_HELPER.getCapacity(this.tool);
        }
    }

    private static class ToolContainerSlot
    extends SmartItemHandlerSlot {
        private final int index;

        public ToolContainerSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.index = index;
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        }

        public void m_6654_() {
            this.m_5852_(this.m_7993_());
        }
    }
}

