/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.worldgen.islands.IslandStructure;

public class WorldgenDatapackRegistryProvider
implements DataProvider {
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final RegistryAccess registryAccess = RegistryAccess.m_206197_();
    private final RegistryOps<JsonElement> registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess);

    public void m_213708_(CachedOutput cache) throws IOException {
        LinkedHashMap<ResourceKey<Structure>, IslandStructure> structures = new LinkedHashMap<ResourceKey<Structure>, IslandStructure>();
        structures.put(TinkerStructures.earthSlimeIsland, IslandStructure.seaBuilder().addDefaultTemplates(TConstruct.getResource("islands/earth/")).addTree(this.reference(TinkerStructures.earthSlimeIslandTree), 1).addSlimyGrass(FoliageType.EARTH).build(new Structure.StructureSettings(this.tag(TinkerTags.Biomes.EARTHSLIME_ISLANDS), WorldgenDatapackRegistryProvider.monsterOverride(EntityType.f_20526_, 4, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        structures.put(TinkerStructures.skySlimeIsland, IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/sky/")).addTree(this.reference(TinkerStructures.skySlimeIslandTree), 1).addSlimyGrass(FoliageType.SKY).vines((Block)TinkerWorld.skySlimeVine.get()).build(new Structure.StructureSettings(this.tag(TinkerTags.Biomes.SKYSLIME_ISLANDS), WorldgenDatapackRegistryProvider.monsterOverride((EntityType)TinkerWorld.skySlimeEntity.get(), 3, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        structures.put(TinkerStructures.clayIsland, IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/dirt/")).addTree(this.reference(TreeFeatures.f_195123_), 4).addTree(this.reference(TreeFeatures.f_195125_), 3).addTree(this.reference(TreeFeatures.f_195127_), 2).addTree(this.reference(TreeFeatures.f_195126_), 1).addTree(this.reference(TreeFeatures.f_195131_), 1).addGrass(Blocks.f_50034_, 7).addGrass(Blocks.f_50035_, 1).build(new Structure.StructureSettings(this.tag(TinkerTags.Biomes.CLAY_ISLANDS), WorldgenDatapackRegistryProvider.monsterOverride((EntityType)TinkerWorld.terracubeEntity.get(), 2, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        structures.put(TinkerStructures.bloodIsland, IslandStructure.seaBuilder().addDefaultTemplates(TConstruct.getResource("islands/blood/")).addTree(this.reference(TinkerStructures.bloodSlimeIslandFungus), 1).addSlimyGrass(FoliageType.BLOOD).build(new Structure.StructureSettings(this.tag(TinkerTags.Biomes.BLOOD_ISLANDS), WorldgenDatapackRegistryProvider.monsterOverride(EntityType.f_20468_, 4, 6), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.NONE)));
        structures.put(TinkerStructures.endSlimeIsland, IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/ender/")).addTree(this.reference(TinkerStructures.enderSlimeTree), 3).addTree(this.reference(TinkerStructures.enderSlimeTreeTall), 17).addSlimyGrass(FoliageType.ENDER).vines((Block)TinkerWorld.enderSlimeVine.get()).build(new Structure.StructureSettings(this.tag(TinkerTags.Biomes.ENDERSLIME_ISLANDS), WorldgenDatapackRegistryProvider.monsterOverride((EntityType)TinkerWorld.enderSlimeEntity.get(), 4, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        LinkedHashMap<String, StructureSet> structureSets = new LinkedHashMap<String, StructureSet>();
        structureSets.put("overworld_ocean_island", this.structureSet((StructurePlacement)new RandomSpreadStructurePlacement(35, 25, RandomSpreadType.LINEAR, 25988585), this.entry(TinkerStructures.earthSlimeIsland, 1)));
        structureSets.put("overworld_sky_island", this.structureSet((StructurePlacement)new RandomSpreadStructurePlacement(40, 15, RandomSpreadType.LINEAR, 14357800), this.entry(TinkerStructures.skySlimeIsland, 4), this.entry(TinkerStructures.clayIsland, 1)));
        structureSets.put("nether_ocean_island", this.structureSet((StructurePlacement)new RandomSpreadStructurePlacement(15, 10, RandomSpreadType.LINEAR, 65245622), this.entry(TinkerStructures.bloodIsland, 1)));
        structureSets.put("end_sky_island", this.structureSet((StructurePlacement)new RandomSpreadStructurePlacement(25, 12, RandomSpreadType.LINEAR, 368963602), this.entry(TinkerStructures.endSlimeIsland, 1)));
        LinkedHashMap<String, Object> biomeModifiers = new LinkedHashMap<String, Object>();
        HolderSet overworld = this.tag(BiomeTags.f_215817_);
        HolderSet nether = this.tag(BiomeTags.f_207612_);
        HolderSet end = this.tag(BiomeTags.f_215818_);
        biomeModifiers.put("cobalt_ore", new ForgeBiomeModifiers.AddFeaturesBiomeModifier(nether, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(TinkerWorld.placedSmallCobaltOre), this.reference(TinkerWorld.placedLargeCobaltOre)}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        biomeModifiers.put("earth_geode", new ForgeBiomeModifiers.AddFeaturesBiomeModifier(overworld, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(TinkerWorld.placedEarthGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        biomeModifiers.put("sky_geode", new ForgeBiomeModifiers.AddFeaturesBiomeModifier(this.and(new HolderSet[]{overworld, this.not((ResourceKey)Registry.f_122885_, (HolderSet)this.or(this.tag(BiomeTags.f_207603_), this.tag(BiomeTags.f_207602_), this.tag(BiomeTags.f_207604_), this.tag(BiomeTags.f_207605_)))}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(TinkerWorld.placedSkyGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        biomeModifiers.put("ichor_geode", new ForgeBiomeModifiers.AddFeaturesBiomeModifier(nether, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(TinkerWorld.placedIchorGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        biomeModifiers.put("ender_geode", new ForgeBiomeModifiers.AddFeaturesBiomeModifier(this.and(new HolderSet[]{end, this.not((ResourceKey)Registry.f_122885_, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(Biomes.f_48210_)}))}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{this.reference(TinkerWorld.placedEnderGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        biomeModifiers.put("spawn_overworld_slime", new ForgeBiomeModifiers.AddSpawnsBiomeModifier(overworld, List.of(new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.skySlimeEntity.get(), 100, 2, 4))));
        biomeModifiers.put("spawn_end_slime", new ForgeBiomeModifiers.AddSpawnsBiomeModifier(end, List.of(new MobSpawnSettings.SpawnerData((EntityType)TinkerWorld.enderSlimeEntity.get(), 10, 2, 4))));
        this.registryName(Registry.f_211073_, structureSets).m_213708_(cache);
        this.registryKey(Registry.f_235725_, structures).m_213708_(cache);
        this.registryName(ForgeRegistries.Keys.BIOME_MODIFIERS, biomeModifiers).m_213708_(cache);
    }

    public String m_6055_() {
        return "Tinkers' Construct Worldgen Datapack Registries";
    }

    private <T> Holder<T> reference(ResourceKey<T> key) {
        ResourceKey registry = ResourceKey.m_135788_((ResourceLocation)key.m_211136_());
        return this.registryAccess.m_175515_(registry).m_214121_(Objects.requireNonNull(key));
    }

    private <T> Holder<T> reference(Holder<T> object) {
        return this.reference((ResourceKey)object.m_203543_().orElseThrow());
    }

    private <T> Holder<T> reference(RegistryObject<T> object) {
        return this.reference(Objects.requireNonNull(object.getKey()));
    }

    private <T> HolderSet<T> tag(TagKey<T> key) {
        return this.registryAccess.m_175515_(key.f_203867_()).m_203561_(key);
    }

    @SafeVarargs
    private <T> AndHolderSet<T> and(HolderSet<T> ... sets) {
        return new AndHolderSet(List.of(sets));
    }

    @SafeVarargs
    private <T> OrHolderSet<T> or(HolderSet<T> ... sets) {
        return new OrHolderSet(List.of(sets));
    }

    private <T> NotHolderSet<T> not(ResourceKey<Registry<T>> key, HolderSet<T> set) {
        return new NotHolderSet(this.registryAccess.m_175515_(key), set);
    }

    private <T> DataProvider registryRL(ResourceKey<Registry<T>> registry, Map<ResourceLocation, T> entries) {
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)this.generator, (ExistingFileHelper)this.existingFileHelper, (String)"tconstruct", this.registryOps, registry, entries);
    }

    private <T> DataProvider registryName(ResourceKey<Registry<T>> registry, Map<String, T> entries) {
        return this.registryRL(registry, entries.entrySet().stream().collect(Collectors.toMap(entry -> TConstruct.getResource((String)entry.getKey()), Map.Entry::getValue)));
    }

    private <T> DataProvider registryKey(ResourceKey<Registry<T>> registry, Map<ResourceKey<T>, T> entries) {
        return this.registryRL(registry, entries.entrySet().stream().collect(Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).m_135782_(), Map.Entry::getValue)));
    }

    private StructureSet structureSet(StructurePlacement placement, StructureSet.StructureSelectionEntry ... structures) {
        return new StructureSet(List.of(structures), placement);
    }

    private StructureSet.StructureSelectionEntry entry(ResourceKey<Structure> structure, int weight) {
        return new StructureSet.StructureSelectionEntry(this.reference(structure), weight);
    }

    private static Map<MobCategory, StructureSpawnOverride> monsterOverride(EntityType<?> entity, int min, int max) {
        return Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(entity, 1, min, max)})));
    }

    public WorldgenDatapackRegistryProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }
}

