/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;

public abstract class AbstractTagProvider<T>
extends GenericDataProvider {
    protected final DataGenerator generator;
    private final String modId;
    private final Predicate<ResourceLocation> staticValuePredicate;
    private final Function<T, ResourceLocation> keyGetter;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<ResourceLocation, TagBuilder> builders = Maps.newLinkedHashMap();

    protected AbstractTagProvider(DataGenerator generator, String modId, String folder, Function<T, ResourceLocation> keyGetter, Predicate<ResourceLocation> staticValuePredicate, ExistingFileHelper existingFileHelper) {
        super(generator, PackType.SERVER_DATA, folder);
        this.generator = generator;
        this.modId = modId;
        this.keyGetter = keyGetter;
        this.staticValuePredicate = staticValuePredicate;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", folder);
    }

    protected abstract void addTags();

    public void m_213708_(CachedOutput cache) throws IOException {
        this.builders.clear();
        this.addTags();
        this.builders.forEach((id, builder) -> {
            List tagEntries = builder.m_215904_();
            List<TagEntry> invalidEntries = tagEntries.stream().filter(value -> !value.m_215940_(this.staticValuePredicate, this.builders::containsKey)).filter(this::missing).toList();
            if (!invalidEntries.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", id, invalidEntries.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            this.saveJson(cache, (ResourceLocation)id, TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(tagEntries, false)).getOrThrow(false, arg_0 -> ((Logger)TConstruct.LOG).error(arg_0)));
        });
    }

    private boolean missing(TagEntry reference) {
        if (reference.isRequired()) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.getId(), this.resourceType);
        }
        return false;
    }

    protected TagAppender<T> tag(TagKey<T> pTag) {
        return new TagAppender<T>(this.modId, this.getOrCreateRawBuilder(pTag), this.keyGetter);
    }

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> pTag) {
        return this.builders.computeIfAbsent(pTag.f_203868_(), location -> {
            this.existingFileHelper.trackGenerated(location, this.resourceType);
            return TagBuilder.m_215899_();
        });
    }

    public record TagAppender<T>(String modID, TagBuilder internalBuilder, Function<T, ResourceLocation> keyGetter) {
        public TagAppender<T> add(T value) {
            this.internalBuilder.m_215900_(this.keyGetter.apply(value));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... values) {
            Stream.of(values).map(this.keyGetter).forEach(arg_0 -> ((TagBuilder)this.internalBuilder).m_215900_(arg_0));
            return this;
        }

        public TagAppender<T> add(ResourceLocation ... ids) {
            for (ResourceLocation id : ids) {
                this.internalBuilder.m_215900_(id);
            }
            return this;
        }

        public TagAppender<T> addOptional(ResourceLocation ... ids) {
            for (ResourceLocation id : ids) {
                this.internalBuilder.m_215905_(id);
            }
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> addTag(TagKey<T> ... tags) {
            for (TagKey<T> tag : tags) {
                this.internalBuilder.m_215907_(tag.f_203868_());
            }
            return this;
        }

        public TagAppender<T> addOptionalTag(ResourceLocation ... tags) {
            for (ResourceLocation tag : tags) {
                this.internalBuilder.m_215909_(tag);
            }
            return this;
        }

        public TagAppender<T> replace() {
            return this.replace(true);
        }

        public TagAppender<T> replace(boolean value) {
            this.internalBuilder.replace(value);
            return this;
        }

        public TagAppender<T> remove(T entry) {
            return this.remove(this.keyGetter.apply(entry));
        }

        @SafeVarargs
        public final TagAppender<T> remove(T first, T ... entries) {
            this.remove(first);
            for (T entry : entries) {
                this.remove(entry);
            }
            return this;
        }

        public TagAppender<T> remove(ResourceLocation location) {
            this.internalBuilder.removeElement(location, this.modID);
            return this;
        }

        public TagAppender<T> remove(ResourceLocation first, ResourceLocation ... locations) {
            this.remove(first);
            for (ResourceLocation location : locations) {
                this.remove(location);
            }
            return this;
        }

        public TagAppender<T> remove(TagKey<T> tag) {
            this.internalBuilder.removeTag(tag.f_203868_(), this.modID);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> remove(TagKey<T> first, TagKey<T> ... tags) {
            this.remove(first);
            for (TagKey<T> tag : tags) {
                this.remove(tag);
            }
            return this;
        }
    }
}

