/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public abstract class AbstractMaterialStatsDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, List<IMaterialStats>> allMaterialStats = new HashMap<MaterialId, List<IMaterialStats>>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialStatsDataProvider(DataGenerator gen, AbstractMaterialDataProvider materials) {
        super(gen, PackType.SERVER_DATA, "tinkering/materials/stats");
        this.materials = materials;
    }

    protected abstract void addMaterialStats();

    public void m_213708_(CachedOutput cache) {
        this.addMaterialStats();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialStats.containsKey(material)) continue;
            throw new IllegalStateException(String.format("Missing material stats for '%s'", material));
        }
        this.allMaterialStats.forEach((materialId, materialStats) -> this.saveJson(cache, (ResourceLocation)materialId, this.convert((List<IMaterialStats>)materialStats)));
    }

    protected void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        this.allMaterialStats.computeIfAbsent(location, materialId -> new ArrayList()).addAll(Arrays.asList(stats));
    }

    protected void addArmorStats(MaterialId location, ArmorSlotType.ArmorBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        IMaterialStats[] stats = new IMaterialStats[4];
        for (ArmorSlotType slotType : ArmorSlotType.values()) {
            stats[slotType.getIndex()] = statBuilder.build(slotType);
        }
        this.addMaterialStats(location, stats);
        if (otherStats.length > 0) {
            this.addMaterialStats(location, otherStats);
        }
    }

    protected void addArmorShieldStats(MaterialId location, ArmorSlotType.ArmorShieldBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        this.addArmorStats(location, statBuilder, otherStats);
        this.addMaterialStats(location, statBuilder.buildShield());
    }

    private MaterialStatJson convert(List<IMaterialStats> stats) {
        return new MaterialStatJson(stats.stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, stat -> AbstractMaterialStatsDataProvider.encodeStats(stat, stat.getType()))));
    }

    private static <T extends IMaterialStats> JsonElement encodeStats(IMaterialStats stats, MaterialStatType<T> type) {
        return type.getLoadable().serialize((Object)stats);
    }
}

