/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class MaterialPartTextureGenerator
extends GenericTextureGenerator {
    public static final String FOLDER = "textures";
    private final DataGenSpriteReader spriteReader;
    private final ExistingFileHelper existingFileHelper;
    private final AbstractPartSpriteProvider partProvider;
    private final AbstractMaterialSpriteProvider[] materialProviders;
    private final GeneratorPartTextureJsonGenerator.StatOverride overrides;
    private static final List<IPartTextureCallback> TEXTURE_CALLBACKS = new ArrayList<IPartTextureCallback>();

    public MaterialPartTextureGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, AbstractMaterialSpriteProvider ... materialProviders) {
        this(generator, existingFileHelper, spriteProvider, GeneratorPartTextureJsonGenerator.StatOverride.EMPTY, materialProviders);
    }

    public MaterialPartTextureGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, GeneratorPartTextureJsonGenerator.StatOverride overrides, AbstractMaterialSpriteProvider ... materialProviders) {
        super(generator, FOLDER);
        this.spriteReader = new DataGenSpriteReader(existingFileHelper, FOLDER);
        this.existingFileHelper = existingFileHelper;
        this.partProvider = spriteProvider;
        this.overrides = overrides;
        this.materialProviders = materialProviders;
    }

    public String m_6055_() {
        StringBuilder name = new StringBuilder();
        name.append("Material Part Generator - ");
        name.append(this.partProvider.getName());
        name.append(" - ");
        name.append(this.materialProviders[0].getName());
        for (int i = 1; i < this.materialProviders.length; ++i) {
            name.append(", ").append(this.materialProviders[i].getName());
        }
        return name.toString();
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        List<AbstractPartSpriteProvider.PartSpriteInfo> parts = this.partProvider.getSprites();
        if (parts.isEmpty()) {
            throw new IllegalStateException(this.partProvider.getName() + " has no parts, must have at least one part to generate");
        }
        BiConsumer<ResourceLocation, NativeImage> saver = (path, image) -> this.saveImage(cache, (ResourceLocation)path, (NativeImage)image);
        BiConsumer<ResourceLocation, JsonObject> metaSaver = (path, meta) -> this.saveMetadata(cache, (ResourceLocation)path, (JsonObject)meta);
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            Collection<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materials = materialProvider.getMaterials().values();
            if (materials.isEmpty()) {
                throw new IllegalStateException(materialProvider.getName() + " has no materials, must have at least one material to generate");
            }
            Predicate<ResourceLocation> shouldGenerate = path -> !this.spriteReader.exists((ResourceLocation)path);
            for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materials) {
                block2: for (AbstractPartSpriteProvider.PartSpriteInfo part : parts) {
                    for (MaterialStatsId statType : part.getStatTypes()) {
                        if (!material.supportStatType(statType) && !this.overrides.hasOverride(statType, material.getTexture())) continue;
                        MaterialPartTextureGenerator.generateSprite(this.spriteReader, material, part, shouldGenerate, saver, metaSaver);
                        continue block2;
                    }
                }
            }
        }
        this.spriteReader.closeAll();
        this.partProvider.cleanCache();
        MaterialPartTextureGenerator.runCallbacks(null, null);
    }

    public static void generateSprite(AbstractSpriteReader spriteReader, AbstractMaterialSpriteProvider.MaterialSpriteInfo material, AbstractPartSpriteProvider.PartSpriteInfo part, Predicate<ResourceLocation> shouldGenerate, BiConsumer<ResourceLocation, NativeImage> saver, BiConsumer<ResourceLocation, JsonObject> metaSaver) {
        ResourceLocation partPath = part.getPath();
        ResourceLocation materialTexture = material.getTexture();
        ResourceLocation spritePath = new ResourceLocation(partPath.m_135827_(), partPath.m_135815_() + "_" + materialTexture.m_135827_() + "_" + materialTexture.m_135815_());
        if (shouldGenerate.test(spritePath)) {
            JsonObject meta;
            String fallback;
            NativeImage base = null;
            String[] stringArray = material.getFallbacks();
            int n = stringArray.length;
            for (int i = 0; i < n && (base = part.getTexture(spriteReader, fallback = stringArray[i])) == null; ++i) {
            }
            if (base == null) {
                base = part.getTexture(spriteReader, "");
            }
            if (base == null) {
                throw new IllegalStateException("Missing sprite at " + partPath + ".png, cannot generate textures");
            }
            ISpriteTransformer transformer = material.getTransformer();
            NativeImage transformed = transformer.transformCopy(base, part.isAllowAnimated());
            spriteReader.track(transformed);
            saver.accept(spritePath, transformed);
            if (part.isAllowAnimated() && (meta = transformer.animationMeta(base)) != null) {
                metaSaver.accept(spritePath, meta);
            }
        }
    }

    public static void registerCallback(IPartTextureCallback callback) {
        TEXTURE_CALLBACKS.add(callback);
    }

    public static void runCallbacks(@Nullable ExistingFileHelper existingFileHelper, @Nullable ResourceManager manager) {
        for (IPartTextureCallback callback : TEXTURE_CALLBACKS) {
            callback.accept(existingFileHelper, manager);
        }
    }

    public static interface IPartTextureCallback {
        public void accept(@Nullable ExistingFileHelper var1, @Nullable ResourceManager var2);
    }
}

