/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.fluid;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.TankCapacityStat;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.Util;

public class TankModule
implements HookProvider,
ToolFluidCapability.FluidModifierHook,
TooltipModifierHook,
VolatileDataModifierHook,
ValidateModifierHook,
ModifierRemovalHook {
    private static final String FLUID_KEY = ToolTankHelper.CAPACITY_STAT.getTranslationKey() + ".fluid";
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolFluidCapability.HOOK, ModifierHooks.TOOLTIP, ModifierHooks.VOLATILE_DATA, ModifierHooks.VALIDATE, ModifierHooks.REMOVE);
    private final ToolTankHelper helper;

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addVolatileData(IToolContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        ToolFluidCapability.addTanks(modifier, volatileData, this);
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        FluidStack current = this.helper.getFluid(tool);
        if (!current.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)FLUID_KEY).m_7220_((Component)Component.m_237110_((String)TankCapacityStat.MB_FORMAT, (Object[])new Object[]{Util.COMMA_FORMAT.format(current.getAmount())}).m_130946_(" ").m_7220_(current.getDisplayName()).m_130938_(style -> style.m_131148_(ToolTankHelper.CAPACITY_STAT.getColor()))));
        }
        tooltip.add(this.helper.getCapacityStat().formatValue(this.helper.getCapacity(tool)));
    }

    @Override
    public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.helper.getCapacity(tool);
    }

    @Override
    public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.helper.getFluid(tool);
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        FluidStack fluid = this.helper.getFluid(tool);
        int capacity = this.helper.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
            this.helper.setFluid(tool, fluid);
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        this.helper.setFluid(tool, FluidStack.EMPTY);
        return null;
    }

    @Override
    public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        modifier.getId();
        if (!resource.isEmpty()) {
            FluidStack current = this.helper.getFluid(tool);
            int capacity = this.helper.getCapacity(tool);
            if (current.isEmpty()) {
                if (action.execute()) {
                    this.helper.setFluid(tool, resource);
                }
                return Math.min(resource.getAmount(), capacity);
            }
            if (current.getAmount() < capacity && current.isFluidEqual(resource)) {
                int filled = Math.min(resource.getAmount(), capacity - current.getAmount());
                if (filled > 0 && action.execute()) {
                    current.grow(filled);
                    this.helper.setFluid(tool, current);
                }
                return filled;
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack current;
        modifier.getId();
        if (!resource.isEmpty() && !(current = this.helper.getFluid(tool)).isEmpty() && current.isFluidEqual(resource)) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), resource.getAmount()));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.helper.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.helper.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current;
        modifier.getId();
        if (maxDrain > 0 && !(current = this.helper.getFluid(tool)).isEmpty()) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), maxDrain));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.helper.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.helper.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public TankModule(ToolTankHelper helper) {
        this.helper = helper;
    }
}

