/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.DamageableMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.OreMeltingRecipe;

public class MeltingRecipeBuilder
extends AbstractRecipeBuilder<MeltingRecipeBuilder> {
    private final Ingredient input;
    private final FluidStack output;
    private final int temperature;
    private final int time;
    @Nullable
    private IMeltingContainer.OreRateType oreRate = null;
    private List<IMeltingContainer.OreRateType> byproductRates = List.of();
    @Nullable
    private int[] unitSizes;
    private final List<FluidStack> byproducts = new ArrayList<FluidStack>();

    public static MeltingRecipeBuilder melting(Ingredient input, FluidStack output, int temperature, int time) {
        if (temperature < 0) {
            throw new IllegalArgumentException("Invalid temperature " + temperature + ", must be greater than zero");
        }
        if (time <= 0) {
            throw new IllegalArgumentException("Invalid time " + time + ", must be greater than zero");
        }
        return new MeltingRecipeBuilder(input, output, temperature, time);
    }

    public static MeltingRecipeBuilder melting(Ingredient input, FluidStack output, float timeFactor) {
        int temperature = output.getFluid().getFluidType().getTemperature(output) - 300;
        return MeltingRecipeBuilder.melting(input, output, temperature, IMeltingRecipe.calcTime(temperature, timeFactor));
    }

    public static MeltingRecipeBuilder melting(Ingredient input, Fluid fluid, int amount, float timeFactor) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), timeFactor);
    }

    public static MeltingRecipeBuilder melting(Ingredient input, Fluid fluid, int amount) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), IMeltingRecipe.calcTimeFactor(amount));
    }

    public MeltingRecipeBuilder setOre(IMeltingContainer.OreRateType rate, IMeltingContainer.OreRateType ... byproductRates) {
        this.oreRate = rate;
        this.byproductRates = List.of(byproductRates);
        return this;
    }

    public MeltingRecipeBuilder setDamagable(int ... unitSizes) {
        this.unitSizes = unitSizes;
        return this;
    }

    public MeltingRecipeBuilder addByproduct(FluidStack fluidStack) {
        this.byproducts.add(fluidStack);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Registry.f_122822_.m_7981_((Object)this.output.getFluid()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.oreRate != null && this.unitSizes != null) {
            throw new IllegalStateException("Builder cannot be both ore and damagable");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "melting");
        if (this.oreRate != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new OreMeltingRecipe(id, this.group, this.input, this.output, this.temperature, this.time, this.byproducts, this.oreRate, this.byproductRates), OreMeltingRecipe.LOADER, advancementId));
        } else if (this.unitSizes != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new DamageableMeltingRecipe(id, this.group, this.input, this.output, this.temperature, this.time, this.byproducts, this.unitSizes[0], List.of((Integer[])Arrays.stream(this.unitSizes, 1, this.unitSizes.length).boxed().toArray(Integer[]::new))), DamageableMeltingRecipe.LOADER, advancementId));
        } else {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MeltingRecipe(id, this.group, this.input, this.output, this.temperature, this.time, this.byproducts), MeltingRecipe.LOADER, advancementId));
        }
    }

    private MeltingRecipeBuilder(Ingredient input, FluidStack output, int temperature, int time) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
    }
}

