/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.data.StructureRepalleter;
import slimeknights.tconstruct.world.data.WorldgenDatapackRegistryProvider;
import slimeknights.tconstruct.world.worldgen.islands.IslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.IslandStructure;
import slimeknights.tconstruct.world.worldgen.trees.ExtraRootVariantPlacer;
import slimeknights.tconstruct.world.worldgen.trees.LeaveVineDecorator;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeFungusConfig;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeFungusFeature;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature;

public final class TinkerStructures
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_structures");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tconstruct");
    private static final DeferredRegister<StructureType<?>> STRUCTURE_TYPE = DeferredRegister.create((ResourceKey)Registry.f_235739_, (String)"tconstruct");
    private static final DeferredRegister<StructurePieceType> STRUCTURE_PIECE = DeferredRegister.create((ResourceKey)Registry.f_122842_, (String)"tconstruct");
    private static final DeferredRegister<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, (String)"tconstruct");
    private static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((ResourceKey)Registry.f_122850_, (String)"tconstruct");
    private static final DeferredRegister<RootPlacerType<?>> ROOT_PLACERS = DeferredRegister.create((ResourceKey)Registry.f_235741_, (String)"tconstruct");
    public static final RegistryObject<BlockStateProviderType<SupplierBlockStateProvider>> supplierBlockstateProvider = BLOCK_STATE_PROVIDER_TYPES.register("supplier_state_provider", () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static final RegistryObject<TreeDecoratorType<LeaveVineDecorator>> leaveVineDecorator = TREE_DECORATORS.register("leave_vines", () -> new TreeDecoratorType(LeaveVineDecorator.CODEC));
    public static final RegistryObject<RootPlacerType<ExtraRootVariantPlacer>> extraRootVariantPlacer = ROOT_PLACERS.register("extra_root_variants", () -> new RootPlacerType(ExtraRootVariantPlacer.CODEC));
    public static final RegistryObject<SlimeTreeFeature> slimeTree = FEATURES.register("slime_tree", () -> new SlimeTreeFeature(SlimeTreeConfig.CODEC));
    public static final RegistryObject<SlimeFungusFeature> slimeFungus = FEATURES.register("slime_fungus", () -> new SlimeFungusFeature(SlimeFungusConfig.CODEC));
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> earthSlimeTree = CONFIGURED_FEATURES.registerStatic("earth_slime_tree", slimeTree, new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> earthSlimeIslandTree = CONFIGURED_FEATURES.registerStatic("earth_slime_island_tree", slimeTree, new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.EARTH)).m_49966_()).baseHeight(4).randomHeight(3).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> skySlimeTree = CONFIGURED_FEATURES.registerStatic("sky_slime_tree", slimeTree, new SlimeTreeConfig.Builder().planted().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.SKY)).m_49966_()).build());
    public static final RegistryObject<ConfiguredFeature<SlimeTreeConfig, SlimeTreeFeature>> skySlimeIslandTree = CONFIGURED_FEATURES.registerStatic("sky_slime_island_tree", slimeTree, new SlimeTreeConfig.Builder().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().m_49966_()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.SKY)).m_49966_()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build());
    public static final RegistryObject<ConfiguredFeature<TreeConfiguration, Feature<TreeConfiguration>>> enderSlimeTree = CONFIGURED_FEATURES.registerSupplier("ender_slime_tree", () -> Feature.f_65760_, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)TinkerWorld.enderbark.getLog()), (TrunkPlacer)new UpwardsBranchingTrunkPlacer(2, 1, 4, (IntProvider)UniformInt.m_146622_((int)1, (int)4), 0.5f, (IntProvider)UniformInt.m_146622_((int)0, (int)1), (HolderSet)Registry.f_122824_.m_203561_(TinkerTags.Blocks.ENDERBARK_LOGS_CAN_GROW_THROUGH)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ENDER))), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 70), ExtraRootVariantPlacer.builder().trunkOffset((IntProvider)UniformInt.m_146622_((int)1, (int)3)).rootBlock((Block)TinkerWorld.enderbarkRoots.get()).canGrowThroughTag(TinkerTags.Blocks.ENDERBARK_ROOTS_CAN_GROW_THROUGH).slimyRoots(TinkerWorld.slimyEnderbarkRoots).buildOptional(), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68249_(List.of(new LeaveVineDecorator((Block)TinkerWorld.enderSlimeVine.get(), 0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER)).m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))), MangrovePropaguleBlock.f_221441_, (IntProvider)UniformInt.m_146622_((int)0, (int)4)), 2, List.of(Direction.DOWN)))).m_68244_().m_68251_());
    public static final RegistryObject<ConfiguredFeature<TreeConfiguration, Feature<TreeConfiguration>>> enderSlimeTreeTall = CONFIGURED_FEATURES.registerSupplier("ender_slime_tree_tall", () -> Feature.f_65760_, () -> new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)TinkerWorld.enderbark.getLog()), (TrunkPlacer)new UpwardsBranchingTrunkPlacer(4, 1, 9, (IntProvider)UniformInt.m_146622_((int)1, (int)6), 0.5f, (IntProvider)UniformInt.m_146622_((int)0, (int)1), (HolderSet)Registry.f_122824_.m_203561_(TinkerTags.Blocks.ENDERBARK_LOGS_CAN_GROW_THROUGH)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ENDER))), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 70), ExtraRootVariantPlacer.builder().trunkOffset((IntProvider)UniformInt.m_146622_((int)3, (int)7)).rootBlock((Block)TinkerWorld.enderbarkRoots.get()).canGrowThroughTag(TinkerTags.Blocks.ENDERBARK_ROOTS_CAN_GROW_THROUGH).slimyRoots(TinkerWorld.slimyEnderbarkRoots).buildOptional(), (FeatureSize)new TwoLayersFeatureSize(3, 0, 2)).m_68249_(List.of(new LeaveVineDecorator((Block)TinkerWorld.enderSlimeVine.get(), 0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER)).m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))), MangrovePropaguleBlock.f_221441_, (IntProvider)UniformInt.m_146622_((int)0, (int)4)), 2, List.of(Direction.DOWN)))).m_68244_().m_68251_());
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> bloodSlimeFungus = CONFIGURED_FEATURES.registerSupplier("blood_slime_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)((Object)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)))).m_49966_(), true));
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> bloodSlimeIslandFungus = CONFIGURED_FEATURES.registerSupplier("blood_slime_island_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_NYLIUM, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)((Object)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)))).m_49966_(), false));
    public static final RegistryObject<ConfiguredFeature<HugeFungusConfiguration, SlimeFungusFeature>> ichorSlimeFungus = CONFIGURED_FEATURES.registerSupplier("ichor_slime_fungus", slimeFungus, () -> new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ICHOR)).m_49966_(), ((CongealedSlimeBlock)((Object)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)))).m_49966_(), false));
    public static final RegistryObject<StructurePieceType> islandPiece = STRUCTURE_PIECE.register("island", () -> IslandPiece::new);
    public static final RegistryObject<StructureType<IslandStructure>> island = STRUCTURE_TYPE.register("island", () -> () -> IslandStructure.CODEC);
    public static final ResourceKey<Structure> earthSlimeIsland = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)TConstruct.getResource("earth_slime_island"));
    public static final ResourceKey<Structure> skySlimeIsland = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)TConstruct.getResource("sky_slime_island"));
    public static final ResourceKey<Structure> clayIsland = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)TConstruct.getResource("clay_island"));
    public static final ResourceKey<Structure> bloodIsland = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)TConstruct.getResource("blood_island"));
    public static final ResourceKey<Structure> endSlimeIsland = ResourceKey.m_135785_((ResourceKey)Registry.f_235725_, (ResourceLocation)TConstruct.getResource("end_slime_island"));

    public TinkerStructures() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FEATURES.register(bus);
        STRUCTURE_TYPE.register(bus);
        STRUCTURE_PIECE.register(bus);
        BLOCK_STATE_PROVIDER_TYPES.register(bus);
        TREE_DECORATORS.register(bus);
        ROOT_PLACERS.register(bus);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        datagenerator.m_236039_(server, (DataProvider)new StructureRepalleter(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new WorldgenDatapackRegistryProvider(datagenerator, existingFileHelper));
    }
}

