/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ArmorDyeingRecipe
implements ITinkerStationRecipe,
IMultiRecipe<IDisplayModifierRecipe> {
    public static final RecordLoadable<ArmorDyeingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.toolRequirement), ArmorDyeingRecipe::new);
    private final ResourceLocation id;
    private final Ingredient toolRequirement;
    @Nullable
    private List<IDisplayModifierRecipe> displayRecipes;

    public ArmorDyeingRecipe(ResourceLocation id, Ingredient toolRequirement) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        ModifierRecipeLookup.addRecipeModifier(null, TinkerModifiers.dyed);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack input = inv.getInput(i);
            if (input.m_41619_()) continue;
            if (!input.m_204117_(Tags.Items.DYES)) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public ItemStack assemble(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable().copy();
        ModDataNBT persistentData = tool.getPersistentData();
        ModifierId key = TinkerModifiers.dyed.getId();
        int nr = 0;
        int nb = 0;
        int ng = 0;
        int brightness = 0;
        int count = 0;
        if (persistentData.contains(key, 3)) {
            int color = persistentData.getInt(key);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            brightness = Math.max(r, Math.max(g, b));
            nr = r;
            nb = b;
            ng = g;
            ++count;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            DyeColor dye;
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_() || (dye = DyeColor.getColor((ItemStack)stack)) == null) continue;
            float[] color = dye.m_41068_();
            int r = (int)(color[0] * 255.0f);
            int g = (int)(color[1] * 255.0f);
            int b = (int)(color[2] * 255.0f);
            brightness += Math.max(r, Math.max(g, b));
            nr += r;
            ng += g;
            nb += b;
            ++count;
        }
        if (count == 0) {
            return ItemStack.f_41583_;
        }
        float scaledBrightness = (float)brightness / (float)count;
        brightness = Math.max(nr /= count, Math.max(ng /= count, nb /= count));
        nr = (int)((float)nr * scaledBrightness / (float)brightness);
        ng = (int)((float)ng * scaledBrightness / (float)brightness);
        nb = (int)((float)nb * scaledBrightness / (float)brightness);
        int finalColor = nr << 16 | ng << 8 | nb;
        persistentData.putInt(key, finalColor);
        ModifierId modifier = TinkerModifiers.dyed.getId();
        if (tool.getModifierLevel(modifier) == 0) {
            tool.addModifier(modifier, 1);
        }
        return tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy()));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.armorDyeingSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> toolInputs = Arrays.stream(this.toolRequirement.m_43908_()).map(stack -> {
                if (stack.m_41720_() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.m_41720_()).getRenderTool();
                }
                return stack;
            }).toList();
            ModifierEntry result = new ModifierEntry((Modifier)TinkerModifiers.dyed.get(), 1);
            this.displayRecipes = Arrays.stream(DyeColor.values()).map(dye -> new DisplayRecipe(result, toolInputs, (DyeColor)dye)).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    private static class DisplayRecipe
    implements IDisplayModifierRecipe {
        private static final int[] TINT_COLORS = new int[16];
        private final List<ItemStack> dyes;
        private final ModifierEntry displayResult;
        private final List<ItemStack> toolWithoutModifier;
        private final List<ItemStack> toolWithModifier;
        private final Component variant;

        private static int getTintColor(DyeColor color) {
            int id = color.m_41060_();
            if (TINT_COLORS[id] == 0) {
                float[] colors = color.m_41068_();
                DisplayRecipe.TINT_COLORS[id] = (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
            }
            return TINT_COLORS[id];
        }

        public DisplayRecipe(ModifierEntry result, List<ItemStack> tools, DyeColor color) {
            this.displayResult = result;
            this.toolWithoutModifier = tools;
            this.dyes = RegistryHelper.getTagValueStream((Registry)Registry.f_122827_, (TagKey)color.getTag()).map(ItemStack::new).toList();
            this.variant = Component.m_237115_((String)("color.minecraft." + color.m_7912_()));
            ModifierId id = result.getModifier().getId();
            int tintColor = DisplayRecipe.getTintColor(color);
            List<ModifierEntry> results = List.of(result);
            this.toolWithModifier = tools.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, results, data -> data.putInt(id, tintColor))).toList();
        }

        @Override
        public int getInputCount() {
            return 1;
        }

        @Override
        public List<ItemStack> getDisplayItems(int slot) {
            if (slot == 0) {
                return this.dyes;
            }
            return Collections.emptyList();
        }

        @Override
        public IntRange getLevel() {
            return new IntRange(1, 1);
        }

        @Override
        public ModifierEntry getDisplayResult() {
            return this.displayResult;
        }

        @Override
        public List<ItemStack> getToolWithoutModifier() {
            return this.toolWithoutModifier;
        }

        @Override
        public List<ItemStack> getToolWithModifier() {
            return this.toolWithModifier;
        }

        @Override
        public Component getVariant() {
            return this.variant;
        }
    }

    public static class Finished
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient toolRequirement;

        public void m_7917_(JsonObject json) {
            json.add("tools", this.toolRequirement.m_43942_());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.armorDyeingSerializer.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }

        public Finished(ResourceLocation id, Ingredient toolRequirement) {
            this.id = id;
            this.toolRequirement = toolRequirement;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }
    }
}

