/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.SingleItemContainer;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class AutosmeltModifier
extends NoLevelsModifier
implements ProcessLootModifierHook {
    private final Cache<Item, Optional<SmeltingRecipe>> recipeCache = CacheBuilder.newBuilder().maximumSize(64L).build();
    private final SingleItemContainer inventory = new SingleItemContainer();

    public AutosmeltModifier() {
        RecipeCacheInvalidator.addReloadListener(client -> {
            if (!client) {
                this.recipeCache.invalidateAll();
            }
        });
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.PROCESS_LOOT);
    }

    private Optional<SmeltingRecipe> findRecipe(ItemStack stack, Level world) {
        this.inventory.setStack(stack);
        return world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)this.inventory, world);
    }

    @Nullable
    private SmeltingRecipe findCachedRecipe(ItemStack stack, Level world) {
        if (stack.m_41782_()) {
            return this.findRecipe(stack, world).orElse(null);
        }
        try {
            return ((Optional)this.recipeCache.get((Object)stack.m_41720_(), () -> this.findRecipe(stack, world))).orElse(null);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private ItemStack smeltItem(ItemStack stack, Level world) {
        if (stack.m_204117_(TinkerTags.Items.AUTOSMELT_BLACKLIST)) {
            return stack;
        }
        SmeltingRecipe recipe = this.findCachedRecipe(stack, world);
        if (recipe != null) {
            this.inventory.setStack(stack);
            ItemStack output = recipe.m_5874_((Container)this.inventory);
            if (stack.m_41613_() > 1) {
                output.m_41764_(output.m_41613_() * stack.m_41613_());
            }
            return output;
        }
        return stack;
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        ServerLevel world = context.m_78952_();
        if (!generatedLoot.isEmpty()) {
            ListIterator<ItemStack> iterator = generatedLoot.listIterator();
            while (iterator.hasNext()) {
                ItemStack smelted;
                ItemStack stack = iterator.next();
                if (stack == (smelted = this.smeltItem(stack, (Level)world))) continue;
                iterator.set(smelted);
            }
        }
    }
}

