/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierCrystalItem
extends Item {
    private static final Component TOOLTIP_MISSING = TConstruct.makeTranslation("item", "modifier_crystal.missing").m_130940_(ChatFormatting.GRAY);
    private static final Component TOOLTIP_APPLY = TConstruct.makeTranslation("item", "modifier_crystal.tooltip").m_130940_(ChatFormatting.GRAY);
    private static final String MODIFIER_KEY = TConstruct.makeTranslationKey("item", "modifier_crystal.modifier_id");
    private static final String TAG_MODIFIER = "modifier";

    public ModifierCrystalItem(Item.Properties props) {
        super(props);
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        ModifierId modifier = ModifierCrystalItem.getModifier(stack);
        if (modifier != null) {
            return Component.m_237110_((String)(this.m_5671_(stack) + ".format"), (Object[])new Object[]{Component.m_237115_((String)Util.makeTranslationKey(TAG_MODIFIER, modifier))});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        ModifierId id = ModifierCrystalItem.getModifier(stack);
        if (id != null) {
            if (ModifierManager.INSTANCE.contains(id)) {
                tooltip.addAll(ModifierManager.INSTANCE.get(id).getDescriptionList());
            }
            tooltip.add(TOOLTIP_APPLY);
            if (advanced.m_7050_()) {
                tooltip.add((Component)Component.m_237110_((String)MODIFIER_KEY, (Object[])new Object[]{id.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add(TOOLTIP_MISSING);
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        ModifierId modifier = ModifierCrystalItem.getModifier(stack);
        if (modifier != null) {
            return modifier.m_135827_();
        }
        return null;
    }

    public static ItemStack withModifier(ModifierId modifier, int count) {
        ItemStack stack = new ItemStack(TinkerModifiers.modifierCrystal.get(), count);
        stack.m_41784_().m_128359_(TAG_MODIFIER, modifier.toString());
        return stack;
    }

    public static ItemStack withModifier(ModifierId modifier) {
        return ModifierCrystalItem.withModifier(modifier, 1);
    }

    @Nullable
    public static ModifierId getModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return ModifierId.tryParse(tag.m_128461_(TAG_MODIFIER));
        }
        return null;
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> items) {
        if (this.m_220152_(category)) {
            ModifierRecipeLookup.getRecipeModifierList().forEach(modifier -> items.add((Object)ModifierCrystalItem.withModifier(modifier.getId())));
        }
    }
}

