/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;

public enum ArmorSlotType implements StringRepresentable
{
    BOOTS(EquipmentSlot.FEET),
    LEGGINGS(EquipmentSlot.LEGS),
    CHESTPLATE(EquipmentSlot.CHEST),
    HELMET(EquipmentSlot.HEAD);

    public static final ArmorSlotType[] TOP_DOWN;
    public static final int[] MAX_DAMAGE_ARRAY;
    public static final int SHIELD_DAMAGE = 22;
    private final EquipmentSlot equipmentSlot;
    private final String serializedName = this.toString().toLowerCase(Locale.ROOT);
    private final int index = this.ordinal();

    @Nullable
    public static ArmorSlotType fromEquipment(EquipmentSlot slotType) {
        return switch (slotType) {
            case EquipmentSlot.FEET -> BOOTS;
            case EquipmentSlot.LEGS -> LEGGINGS;
            case EquipmentSlot.CHEST -> CHESTPLATE;
            case EquipmentSlot.HEAD -> HELMET;
            default -> null;
        };
    }

    private ArmorSlotType(EquipmentSlot equipmentSlot) {
        this.equipmentSlot = equipmentSlot;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public int getIndex() {
        return this.index;
    }

    static {
        TOP_DOWN = new ArmorSlotType[]{HELMET, CHESTPLATE, LEGGINGS, BOOTS};
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }

    public static interface ArmorShieldBuilder<T>
    extends ArmorBuilder<T> {
        public T buildShield();
    }

    public static interface ArmorBuilder<T> {
        public T build(ArmorSlotType var1);
    }
}

