/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class CraftingTableRepairKitRecipe
extends CustomRecipe {
    public CraftingTableRepairKitRecipe(ResourceLocation id) {
        super(id);
    }

    protected boolean toolMatches(ItemStack stack) {
        return stack.m_204117_(TinkerTags.Items.DURABILITY);
    }

    @Nullable
    protected Pair<ToolStack, ItemStack> getRelevantInputs(CraftingContainer inv) {
        ToolStack tool = null;
        ItemStack repairKit = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IRepairKitItem) {
                if (repairKit != null) {
                    return null;
                }
                MaterialId inputMaterial = IMaterialItem.getMaterialFromStack(stack).getId();
                if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
                    return null;
                }
                repairKit = stack;
                continue;
            }
            if (this.toolMatches(stack)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (tool.isBroken() || tool.getDamage() != 0) continue;
                return null;
            }
            return null;
        }
        if (tool == null || repairKit == null) {
            return null;
        }
        return Pair.of(tool, repairKit);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Pair<ToolStack, ItemStack> inputs = this.getRelevantInputs(inv);
        return inputs != null && MaterialRepairToolHook.canRepairWith((IToolStackView)inputs.getFirst(), IMaterialItem.getMaterialFromStack((ItemStack)inputs.getSecond()).getId());
    }

    protected float getRepairAmount(IToolStackView tool, ItemStack repairStack) {
        return MaterialRepairToolHook.repairAmount(tool, IMaterialItem.getMaterialFromStack(repairStack).getId());
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack repairKit;
        Pair<ToolStack, ItemStack> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ((ToolStack)inputs.getFirst()).copy();
        float repairAmount = this.getRepairAmount(tool, repairKit = (ItemStack)inputs.getSecond());
        if (repairAmount > 0.0f) {
            float f;
            Item item = repairKit.m_41720_();
            if (item instanceof IRepairKitItem) {
                IRepairKitItem kit = (IRepairKitItem)item;
                f = kit.getRepairAmount();
            } else {
                f = ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
            }
            repairAmount *= f / 3.0f;
            for (ModifierEntry entry : tool.getModifierList()) {
                repairAmount = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
                if (!(repairAmount <= 0.0f)) continue;
                return tool.createStack();
            }
            ToolDamageUtil.repair(tool, (int)repairAmount);
        }
        return tool.createStack();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.craftingTableRepairSerializer.get();
    }
}

