/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.PartBuilderContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.PartBuilderContainerMenu;

public class PartBuilderBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int MATERIAL_SLOT = 0;
    public static final int PATTERN_SLOT = 1;
    private static final Component NAME = TConstruct.makeTranslation("gui", "part_builder");
    private final LazyResultContainer craftingResult;
    private final PartBuilderContainerWrapper inventoryWrapper;
    @Nullable
    private Map<Pattern, IPartBuilderRecipe> recipes = null;
    @Nullable
    private List<Pattern> sortedButtons = null;
    private Pattern selectedPattern = null;
    private int selectedPatternIndex = -2;

    public PartBuilderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TinkerTables.partBuilderTile.get(), pos, state, NAME, 2);
        this.itemHandler = new ConfigurableInvWrapperCapability((Container)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new PartBuilderContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    protected Map<Pattern, IPartBuilderRecipe> getCurrentRecipes() {
        if (this.f_58857_ == null) {
            return Collections.emptyMap();
        }
        if (this.recipes == null) {
            if (this.m_8020_(1).m_41619_()) {
                this.recipes = Collections.emptyMap();
                this.sortedButtons = Collections.emptyList();
            } else {
                record PatternRecipe(Pattern pattern, IPartBuilderRecipe recipe) {
                }
                this.recipes = this.f_58857_.m_7465_().m_44054_((RecipeType)TinkerRecipeTypes.PART_BUILDER.get()).values().stream().filter(r -> r.partialMatch(this.inventoryWrapper)).sorted(Comparator.comparing(Recipe::m_6423_)).flatMap(r -> r.getPatterns(this.inventoryWrapper).map(p -> new PatternRecipe((Pattern)((Object)((Object)p)), (IPartBuilderRecipe)r))).collect(Collectors.toMap(PatternRecipe::pattern, PatternRecipe::recipe, (a, b) -> a));
                this.sortedButtons = this.recipes.entrySet().stream().sorted(Comparator.comparingInt(ent -> ((IPartBuilderRecipe)ent.getValue()).getCost()).thenComparing(Map.Entry::getKey)).map(Map.Entry::getKey).collect(Collectors.toList());
            }
        }
        return this.recipes;
    }

    public List<Pattern> getSortedButtons() {
        if (this.f_58857_ == null) {
            return Collections.emptyList();
        }
        if (this.sortedButtons == null) {
            this.getCurrentRecipes();
        }
        return this.sortedButtons;
    }

    public int getSelectedIndex() {
        if (this.selectedPatternIndex == -2) {
            this.selectedPatternIndex = this.selectedPattern != null ? this.getSortedButtons().indexOf((Object)this.selectedPattern) : -1;
        }
        return this.selectedPatternIndex;
    }

    @Nullable
    public IPartBuilderRecipe getPartRecipe() {
        if (this.selectedPattern != null) {
            return this.getCurrentRecipes().get((Object)this.selectedPattern);
        }
        return null;
    }

    @Nullable
    public IPartBuilderRecipe getFirstRecipe() {
        List<Pattern> sortedButtons = this.getSortedButtons();
        if (sortedButtons.isEmpty()) {
            return null;
        }
        return this.getCurrentRecipes().get((Object)sortedButtons.get(0));
    }

    @Nullable
    public IMaterialValue getMaterialRecipe() {
        return this.inventoryWrapper.getMaterial();
    }

    private void refresh(boolean refreshRecipeList) {
        if (refreshRecipeList) {
            this.recipes = null;
            this.sortedButtons = null;
        }
        this.selectedPatternIndex = -2;
        this.craftingResult.m_6211_();
        if (refreshRecipeList) {
            this.syncScreenToRelevantPlayers();
        }
    }

    public void selectRecipe(@Nullable Pattern pattern) {
        this.selectedPattern = pattern != null && this.getCurrentRecipes().containsKey((Object)pattern) ? pattern : null;
        this.refresh(false);
    }

    public void selectRecipe(int index) {
        List<Pattern> list;
        this.selectedPattern = index < 0 ? null : (index < (list = this.getSortedButtons()).size() ? list.get(index) : null);
        this.refresh(false);
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack original = this.m_8020_(slot);
        super.m_6836_(slot, stack);
        if (slot == 0) {
            if (original.m_41720_() != stack.m_41720_() || !ItemStack.m_41658_((ItemStack)original, (ItemStack)stack)) {
                this.inventoryWrapper.refreshMaterial();
                this.refresh(true);
            } else if (original.m_41613_() != stack.m_41613_() || original == stack) {
                this.craftingResult.m_6211_();
                this.syncScreenToRelevantPlayers();
            }
        } else if (original.m_41720_() != stack.m_41720_()) {
            this.refresh(true);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuId, Inventory playerInventory, Player playerEntity) {
        return new PartBuilderContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public ItemStack calcResult(@Nullable Player player) {
        IPartBuilderRecipe recipe;
        if (this.f_58857_ != null && (recipe = this.getPartRecipe()) != null && recipe.m_5818_((Container)this.inventoryWrapper, this.f_58857_)) {
            return recipe.assemble(this.inventoryWrapper, this.selectedPattern);
        }
        return ItemStack.f_41583_;
    }

    private void shrinkSlot(int slot, int amount, Player player) {
        if (amount <= 0) {
            return;
        }
        ItemStack stack = this.m_8020_(slot);
        if (!stack.m_41619_()) {
            ItemStack container = stack.getCraftingRemainingItem().m_41777_();
            if (amount > 1) {
                container.m_41764_(container.m_41613_() * amount);
            }
            if (stack.m_41613_() <= amount) {
                this.m_6836_(slot, container);
            } else {
                stack.m_41774_(amount);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)container);
            }
        }
    }

    @Override
    public void onCraft(Player player, ItemStack result, int amount) {
        ItemStack leftover;
        if (amount == 0 || this.f_58857_ == null) {
            return;
        }
        IPartBuilderRecipe recipe = this.getPartRecipe();
        if (recipe == null) {
            return;
        }
        result.m_41678_(this.f_58857_, player, amount);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)result, (Container)this.inventoryWrapper);
        this.playCraftSound(player);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !(leftover = recipe.getLeftover(this.inventoryWrapper, this.selectedPattern)).m_41619_()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
        }
        this.shrinkSlot(0, recipe.getItemsUsed(this.inventoryWrapper), player);
        if (!this.m_8020_(1).m_204117_(TinkerTags.Items.REUSABLE_PATTERNS)) {
            this.shrinkSlot(1, 1, player);
        }
        this.syncScreenToRelevantPlayers();
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    public PartBuilderContainerWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }
}

