/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.shared.block.entity.TableBlockEntity;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.AbstractCastingBlock;
import slimeknights.tconstruct.smeltery.block.entity.inventory.CastingContainerWrapper;
import slimeknights.tconstruct.smeltery.block.entity.inventory.MoldingContainerWrapper;
import slimeknights.tconstruct.smeltery.block.entity.tank.CastingFluidHandler;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public abstract class CastingBlockEntity
extends TableBlockEntity
implements WorldlyContainer,
FluidUpdatePacket.IFluidPacketReceiver {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private static final String TAG_TANK = "tank";
    private static final String TAG_TIMER = "timer";
    private static final String TAG_RECIPE = "recipe";
    private static final String TAG_REDSTONE = "redstone";
    private static final Component NAME = TConstruct.makeTranslation("gui", "casting");
    public static final BlockEntityTicker<CastingBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.serverTick(level, pos);
    public static final BlockEntityTicker<CastingBlockEntity> CLIENT_TICKER = (level, pos, state, self) -> self.clientTick(level, pos);
    private final CastingFluidHandler tank = new CastingFluidHandler(this);
    private final LazyOptional<CastingFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private final RecipeType<ICastingRecipe> castingType;
    private final CastingContainerWrapper castingInventory;
    private int timer;
    private int coolingTime = -1;
    private ICastingRecipe currentRecipe;
    private ResourceLocation recipeName;
    private ICastingRecipe lastCastingRecipe;
    private ItemStack lastOutput = null;
    private final boolean requireCast;
    private final TagKey<Item> emptyCastTag;
    private final RecipeType<MoldingRecipe> moldingType;
    private final MoldingContainerWrapper moldingInventory;
    private MoldingRecipe lastMoldingRecipe;
    private boolean lastRedstone = false;
    private int lastAnalogSignal;
    private static final String KEY_FILLED = Mantle.makeDescriptionId((String)"block", (String)"tank.filled");
    private static final String KEY_DRAINED = Mantle.makeDescriptionId((String)"block", (String)"tank.drained");

    protected CastingBlockEntity(BlockEntityType<?> beType, BlockPos pos, BlockState state, RecipeType<ICastingRecipe> castingType, RecipeType<MoldingRecipe> moldingType, TagKey<Item> emptyCastTag) {
        super(beType, pos, state, NAME, 2, 1);
        AbstractCastingBlock casting;
        Block block = state.m_60734_();
        this.requireCast = block instanceof AbstractCastingBlock && (casting = (AbstractCastingBlock)block).isRequireCast();
        this.emptyCastTag = emptyCastTag;
        this.itemHandler = new SidedInvWrapper((WorldlyContainer)this, Direction.DOWN);
        this.castingType = castingType;
        this.moldingType = moldingType;
        this.castingInventory = new CastingContainerWrapper(this);
        this.moldingInventory = new MoldingContainerWrapper((IItemHandler)this.itemHandler, 0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    private boolean interactWithFluidItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack)) {
            IFluidContainerTransfer.TransferResult result;
            FluidStack currentFluid = this.tank.getFluid();
            IFluidContainerTransfer transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid);
            if (transfer != null && (result = transfer.transfer(stack, currentFluid, (IFluidHandler)this.tank)) != null) {
                if (result.didFill()) {
                    CastingBlockEntity.playFillSound(this.f_58857_, this.f_58858_, player, result.fluid());
                } else {
                    CastingBlockEntity.playEmptySound(this.f_58857_, this.f_58858_, player, result.fluid());
                }
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)result.stack()));
                return true;
            }
            return false;
        }
        ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (itemCapability.isPresent()) {
            IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
            FluidStack transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, (IFluidHandler)this.tank, (int)Integer.MAX_VALUE);
            if (!transferred.isEmpty()) {
                CastingBlockEntity.playEmptySound(this.f_58857_, this.f_58858_, player, transferred);
            } else if (!this.tank.isEmpty() && !(transferred = FluidTransferHelper.tryTransfer((IFluidHandler)this.tank, (IFluidHandler)itemHandler, (int)Integer.MAX_VALUE)).isEmpty()) {
                CastingBlockEntity.playFillSound(this.f_58857_, this.f_58858_, player, transferred);
            }
            if (!transferred.isEmpty()) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemHandler.getContainer()));
                return true;
            }
        }
        return false;
    }

    public void interact(Player player, InteractionHand hand) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.coolingTime >= 0 && this.timer > 0) {
            return;
        }
        ItemStack held = player.m_21120_(hand);
        if (this.interactWithFluidItem(player, hand, held) || !this.tank.isEmpty()) {
            return;
        }
        ItemStack input = this.m_8020_(0);
        ItemStack output = this.m_8020_(1);
        if (!input.m_41619_() && output.m_41619_()) {
            this.moldingInventory.setPattern(held);
            MoldingRecipe recipe = this.findMoldingRecipe();
            if (recipe != null) {
                ItemStack result = recipe.m_5874_((Container)this.moldingInventory);
                result.m_41678_(this.f_58857_, player, 1);
                if (held.m_41619_()) {
                    this.m_6836_(0, ItemStack.f_41583_);
                    player.m_21008_(hand, result);
                } else {
                    this.m_6836_(0, result);
                    if (!recipe.isPatternConsumed()) {
                        this.m_6836_(1, ItemHandlerHelper.copyStackWithSize((ItemStack)held, (int)1));
                        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
                    }
                    held.m_41774_(1);
                    player.m_21008_(hand, held.m_41619_() ? ItemStack.f_41583_ : held);
                }
                this.moldingInventory.setPattern(ItemStack.f_41583_);
                return;
            }
            if (!held.m_41619_()) {
                this.moldingInventory.setPattern(ItemStack.f_41583_);
                recipe = this.findMoldingRecipe();
                if (recipe != null) {
                    this.m_6836_(0, ItemStack.f_41583_);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)recipe.m_5874_((Container)this.moldingInventory), (int)player.m_150109_().f_35977_);
                    return;
                }
            }
            this.moldingInventory.setPattern(ItemStack.f_41583_);
        }
        if (input.m_41619_() && output.m_41619_()) {
            if (!held.m_41619_()) {
                ItemStack stack = held.m_41620_(this.stackSizeLimit);
                player.m_21008_(hand, held.m_41619_() ? ItemStack.f_41583_ : held);
                this.m_6836_(0, stack);
            }
        } else {
            int slot = output.m_41619_() ? 0 : 1;
            ItemStack stack = this.m_8020_(slot);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack, (int)player.m_150109_().f_35977_);
            this.m_6836_(slot, ItemStack.f_41583_);
            if (slot == 1) {
                this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack original = this.m_8020_(slot);
        super.m_6836_(slot, stack);
        if (original.m_41619_() != stack.m_41619_()) {
            this.updateAnalogSignal();
        }
    }

    public void handleRedstone(boolean hasSignal) {
        if (this.lastRedstone != hasSignal) {
            if (hasSignal && this.f_58857_ != null) {
                this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 2);
            }
            this.lastRedstone = hasSignal;
        }
    }

    public void swap() {
        if (this.currentRecipe == null) {
            ItemStack output = this.m_8020_(1);
            this.m_6836_(1, this.m_8020_(0));
            this.m_6836_(0, output);
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), Sounds.CASTING_CLICKS.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.tank.isEmpty() && index == 0 && !this.isStackInSlot(1);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return this.tank.isEmpty() && index == 1;
    }

    private void serverTick(Level level, BlockPos pos) {
        if (this.currentRecipe == null) {
            return;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (this.coolingTime >= 0) {
            ++this.timer;
            if (this.timer >= this.coolingTime) {
                if (!this.currentRecipe.m_5818_((Container)this.castingInventory, level)) {
                    this.currentRecipe = this.findCastingRecipe();
                    this.recipeName = null;
                    if (this.currentRecipe == null || this.currentRecipe.getFluidAmount(this.castingInventory) > currentFluid.getAmount()) {
                        this.timer = 0;
                        this.updateAnalogSignal();
                        return;
                    }
                }
                ItemStack output = this.currentRecipe.m_5874_((Container)this.castingInventory);
                if (this.currentRecipe.switchSlots() != this.lastRedstone) {
                    if (!this.currentRecipe.isConsumed()) {
                        this.m_6836_(1, this.m_8020_(0));
                    }
                    this.m_6836_(0, output);
                    level.m_5594_(null, this.m_58899_(), Sounds.CASTING_CLICKS.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    if (this.currentRecipe.isConsumed()) {
                        this.m_6836_(0, ItemStack.f_41583_);
                    }
                    this.m_6836_(1, output);
                }
                level.m_5594_(null, pos, Sounds.CASTING_COOLS.getSound(), SoundSource.BLOCKS, 0.5f, 4.0f);
                this.reset();
            } else {
                this.updateAnalogSignal();
            }
        }
    }

    private void clientTick(Level level, BlockPos pos) {
        if (this.currentRecipe == null) {
            return;
        }
        FluidStack currentFluid = this.tank.getFluid();
        if (currentFluid.getAmount() >= this.tank.getCapacity() && !currentFluid.isEmpty()) {
            ++this.timer;
            if (level.f_46441_.m_188501_() > 0.9f) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + level.f_46441_.m_188500_(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    private ICastingRecipe findCastingRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.lastCastingRecipe != null && this.lastCastingRecipe.m_5818_((Container)this.castingInventory, this.f_58857_)) {
            return this.lastCastingRecipe;
        }
        ICastingRecipe castingRecipe = this.f_58857_.m_7465_().m_44015_(this.castingType, (Container)this.castingInventory, this.f_58857_).orElse(null);
        if (castingRecipe != null) {
            this.lastCastingRecipe = castingRecipe;
        }
        return castingRecipe;
    }

    @Nullable
    private MoldingRecipe findMoldingRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.lastMoldingRecipe != null && this.lastMoldingRecipe.matches(this.moldingInventory, this.f_58857_)) {
            return this.lastMoldingRecipe;
        }
        Optional newRecipe = this.f_58857_.m_7465_().m_44015_(this.moldingType, (Container)this.moldingInventory, this.f_58857_);
        if (newRecipe.isPresent()) {
            this.lastMoldingRecipe = (MoldingRecipe)newRecipe.get();
            return this.lastMoldingRecipe;
        }
        return null;
    }

    public int initNewCasting(FluidStack fluid, IFluidHandler.FluidAction action) {
        boolean hasOutput;
        if (this.currentRecipe != null || this.recipeName != null) {
            return 0;
        }
        boolean hasInput = !this.m_8020_(0).m_41619_();
        boolean bl = hasOutput = !this.m_8020_(1).m_41619_();
        if (hasInput && hasOutput) {
            return 0;
        }
        this.castingInventory.setFluid(fluid);
        if (!hasOutput) {
            if (!hasInput && this.requireCast) {
                return 0;
            }
            this.castingInventory.useInput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.currentRecipe = castingRecipe;
                    this.recipeName = null;
                    this.lastOutput = null;
                }
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        } else {
            this.castingInventory.useOutput();
            ICastingRecipe castingRecipe = this.findCastingRecipe();
            if (castingRecipe != null) {
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.currentRecipe = castingRecipe;
                    this.recipeName = null;
                    this.lastOutput = null;
                    this.m_6836_(0, this.m_8020_(1));
                    this.m_6836_(1, ItemStack.f_41583_);
                    this.castingInventory.useInput();
                }
                return castingRecipe.getFluidAmount(this.castingInventory);
            }
        }
        return 0;
    }

    public void reset() {
        this.timer = 0;
        this.currentRecipe = null;
        this.recipeName = null;
        this.lastOutput = null;
        this.castingInventory.setFluid(FluidStack.EMPTY);
        this.tank.reset();
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack.getAmount() >= this.tank.getCapacity() && this.currentRecipe != null) {
            this.castingInventory.setFluid(fluidStack);
            this.coolingTime = Math.max(0, this.currentRecipe.getCoolingTime(this.castingInventory));
        } else {
            this.coolingTime = -1;
        }
        this.setChangedFast();
        this.updateAnalogSignal();
        Level world = this.m_58904_();
        if (world != null && !world.f_46443_) {
            BlockPos pos = this.m_58899_();
            TinkerNetwork.getInstance().sendToClientsAround(new FluidUpdatePacket(pos, fluidStack), (LevelAccessor)world, pos);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.reset();
        } else {
            int capacity = this.initNewCasting(fluid, IFluidHandler.FluidAction.EXECUTE);
            if (capacity > 0) {
                this.tank.setCapacity(capacity);
            }
        }
        this.tank.setFluid(fluid);
        this.onContentsChanged();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return null;
    }

    public ItemStack getRecipeOutput() {
        if (this.lastOutput == null) {
            if (this.currentRecipe == null) {
                return ItemStack.f_41583_;
            }
            this.castingInventory.setFluid(this.tank.getFluid());
            this.lastOutput = this.currentRecipe.m_5874_((Container)this.castingInventory);
        }
        return this.lastOutput;
    }

    private void updateAnalogSignal() {
        int newStrength;
        if (!(this.f_58857_ != null && this.f_58857_.f_46443_ || (newStrength = this.getAnalogSignal()) == this.lastAnalogSignal)) {
            this.lastAnalogSignal = newStrength;
            if (this.f_58857_ != null) {
                this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            }
        }
    }

    public int getAnalogSignal() {
        if (this.isStackInSlot(1)) {
            return 15;
        }
        if (this.coolingTime > 0) {
            return 11 + this.timer * 4 / this.coolingTime;
        }
        int capacity = this.tank.getCapacity();
        if (capacity > 0) {
            return 2 + this.tank.getFluid().getAmount() * 9 / capacity;
        }
        if (this.isStackInSlot(0)) {
            return 1;
        }
        return 0;
    }

    private void loadRecipe(Level level, ResourceLocation name) {
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            RecipeHelper.getRecipe((RecipeManager)level.m_7465_(), (ResourceLocation)name, ICastingRecipe.class).ifPresent(recipe -> {
                this.currentRecipe = recipe;
                this.castingInventory.setFluid(fluid);
                this.tank.setCapacity(recipe.getFluidAmount(this.castingInventory));
                if (fluid.getAmount() >= this.tank.getCapacity()) {
                    this.coolingTime = recipe.getCoolingTime(this.castingInventory);
                }
            });
        }
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (this.recipeName != null) {
            this.loadRecipe(pLevel, this.recipeName);
            this.recipeName = null;
        }
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128379_(TAG_REDSTONE, this.lastRedstone);
    }

    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        tags.m_128365_(TAG_TANK, (Tag)this.tank.writeToTag(new CompoundTag()));
        if (this.currentRecipe != null || this.recipeName != null) {
            tags.m_128405_(TAG_TIMER, this.timer);
        }
        if (this.currentRecipe != null) {
            tags.m_128359_(TAG_RECIPE, this.currentRecipe.m_6423_().toString());
        } else if (this.recipeName != null) {
            tags.m_128359_(TAG_RECIPE, this.recipeName.toString());
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.tank.readFromTag(tags.m_128469_(TAG_TANK));
        this.timer = tags.m_128451_(TAG_TIMER);
        if (tags.m_128425_(TAG_RECIPE, 8)) {
            ResourceLocation name = new ResourceLocation(tags.m_128461_(TAG_RECIPE));
            if (this.f_58857_ != null) {
                this.loadRecipe(this.f_58857_, name);
            } else {
                this.recipeName = name;
            }
        }
        this.lastRedstone = tags.m_128471_(TAG_REDSTONE);
    }

    @Nullable
    public static <CAST extends CastingBlockEntity, RET extends BlockEntity> BlockEntityTicker<RET> getTicker(Level level, BlockEntityType<RET> check, BlockEntityType<CAST> casting) {
        return BlockEntityHelper.castTicker(check, casting, level.f_46443_ ? CLIENT_TICKER : SERVER_TICKER);
    }

    private static void playEmptySound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getEmptySound((FluidStack)transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_FILLED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    private static void playFillSound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, FluidTransferHelper.getFillSound((FluidStack)transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237110_((String)KEY_DRAINED, (Object[])new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    public CastingFluidHandler getTank() {
        return this.tank;
    }

    public int getTimer() {
        return this.timer;
    }

    public int getCoolingTime() {
        return this.coolingTime;
    }

    public TagKey<Item> getEmptyCastTag() {
        return this.emptyCastTag;
    }

    public static class Table
    extends CastingBlockEntity {
        public Table(BlockPos pos, BlockState state) {
            super((BlockEntityType)TinkerSmeltery.table.get(), pos, state, (RecipeType<ICastingRecipe>)((RecipeType)TinkerRecipeTypes.CASTING_TABLE.get()), (RecipeType<MoldingRecipe>)((RecipeType)TinkerRecipeTypes.MOLDING_TABLE.get()), TinkerTags.Items.TABLE_EMPTY_CASTS);
        }
    }

    public static class Basin
    extends CastingBlockEntity {
        public Basin(BlockPos pos, BlockState state) {
            super((BlockEntityType)TinkerSmeltery.basin.get(), pos, state, (RecipeType<ICastingRecipe>)((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get()), (RecipeType<MoldingRecipe>)((RecipeType)TinkerRecipeTypes.MOLDING_BASIN.get()), TinkerTags.Items.BASIN_EMPTY_CASTS);
        }
    }
}

