/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "modifiers.title");
    private static final List<Component> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
    private static final List<Component> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
    private static final String KEY_MIN = TConstruct.makeTranslationKey("jei", "modifiers.level.min");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.level.max");
    private static final String KEY_RANGE = TConstruct.makeTranslationKey("jei", "modifiers.level.range");
    private static final String KEY_EXACT = TConstruct.makeTranslationKey("jei", "modifiers.level.exact");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124, 10);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private final Map<SlotType, TextureAtlasSprite> slotTypeSprites = new HashMap<SlotType, TextureAtlasSprite>();
    private static List<ItemStack> SLIMESKULL_HELMETS = null;

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CreativeSlotItem.withSlot(new ItemStack(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public RecipeType<IDisplayModifierRecipe> getRecipeType() {
        return TConstructJEIConstants.MODIFIERS;
    }

    public Component getTitle() {
        return TITLE;
    }

    private void drawSlot(PoseStack matrices, IDisplayModifierRecipe recipe, int slot, int x, int y) {
        List<ItemStack> stacks = recipe.getDisplayItems(slot);
        if (stacks.isEmpty()) {
            this.slotIcons[slot].draw(matrices, x + 1, y + 1);
        }
    }

    private void drawSlotType(PoseStack matrices, @Nullable SlotType slotType, int x, int y) {
        TextureAtlasSprite sprite;
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.slotTypeSprites.containsKey(slotType)) {
            sprite = this.slotTypeSprites.get(slotType);
        } else {
            ModelManager modelManager = minecraft.m_91304_();
            BakedModel model = minecraft.m_91291_().m_115103_().m_109394_((Item)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.m_7343_() instanceof NBTKeyModel.Overrides) {
                Material material = ((NBTKeyModel.Overrides)model.m_7343_()).getTexture(slotType == null ? "slotless" : slotType.getName());
                sprite = modelManager.m_119428_(material.m_119193_()).m_118316_(material.m_119203_());
            } else {
                sprite = modelManager.m_119428_(InventoryMenu.f_39692_).m_118316_(MissingTextureAtlasSprite.m_118071_());
            }
            this.slotTypeSprites.put(slotType, sprite);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Screen.m_93200_((PoseStack)matrices, (int)x, (int)y, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    public void draw(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrices, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        this.drawSlot(matrices, recipe, 0, 2, 32);
        this.drawSlot(matrices, recipe, 1, 24, 14);
        this.drawSlot(matrices, recipe, 2, 46, 32);
        this.drawSlot(matrices, recipe, 3, 42, 57);
        this.drawSlot(matrices, recipe, 4, 6, 57);
        ModifierEntry result = recipe.getDisplayResult();
        if (result.getHook(ModifierHooks.REQUIREMENTS).requirementsError(result) != null) {
            this.requirements.draw(matrices, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(matrices, 83, 59);
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Component levelText = null;
        Component variant = recipe.getVariant();
        if (variant != null) {
            levelText = variant;
        } else {
            IntRange level = recipe.getLevel();
            int min = level.min();
            int max = level.max();
            if (min == 1) {
                if (max < ModifierEntry.VALID_LEVEL.max()) {
                    levelText = Component.m_237110_((String)KEY_MAX, (Object[])new Object[]{max});
                }
            } else {
                levelText = min == max ? Component.m_237110_((String)KEY_EXACT, (Object[])new Object[]{min}) : (max == ModifierEntry.VALID_LEVEL.max() ? Component.m_237110_((String)KEY_MIN, (Object[])new Object[]{min}) : Component.m_237110_((String)KEY_RANGE, (Object[])new Object[]{min, max}));
            }
        }
        if (levelText != null) {
            fontRenderer.m_92889_(matrices, levelText, 86.0f - (float)fontRenderer.m_92852_((FormattedText)levelText) / 2.0f, 16.0f, Color.GRAY.getRGB());
        }
        if ((slots = recipe.getSlots()) == null) {
            this.drawSlotType(matrices, null, 110, 58);
        } else {
            this.drawSlotType(matrices, slots.type(), 110, 58);
            String text = Integer.toString(slots.count());
            fontRenderer.m_92883_(matrices, text, (float)(111 - fontRenderer.m_92895_(text)), 63.0f, Color.GRAY.getRGB());
        }
    }

    public List<Component> getTooltipStrings(IDisplayModifierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Component requirements;
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        ModifierEntry result = recipe.getDisplayResult();
        if (GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16) && (requirements = result.getHook(ModifierHooks.REQUIREMENTS).requirementsError(result)) != null) {
            return Collections.singletonList(requirements);
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 58, 24, 16)) {
            SlotType.SlotCount slots = recipe.getSlots();
            if (slots != null) {
                int count = slots.count();
                if (count == 1) {
                    return Collections.singletonList(Component.m_237110_((String)KEY_SLOT, (Object[])new Object[]{slots.type().getDisplayName()}));
                }
                if (count > 1) {
                    return Collections.singletonList(Component.m_237110_((String)KEY_SLOTS, (Object[])new Object[]{slots.count(), slots.type().getDisplayName()}));
                }
            } else {
                return TEXT_FREE;
            }
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayModifierRecipe recipe, IFocusGroup focuses) {
        IFocus focus;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 33).addItemStacks(recipe.getDisplayItems(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 25, 15).addItemStacks(recipe.getDisplayItems(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 33).addItemStacks(recipe.getDisplayItems(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 43, 58).addItemStacks(recipe.getDisplayItems(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 58).addItemStacks(recipe.getDisplayItems(4));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 3).setCustomRenderer(TConstructJEIConstants.MODIFIER_TYPE, (IIngredientRenderer)this.modifierRenderer).addIngredient(TConstructJEIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
        List<ItemStack> toolWithoutModifier = recipe.getToolWithoutModifier();
        List<ItemStack> toolWithModifier = recipe.getToolWithModifier();
        Item slimeskull = (Item)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
        for (ItemStack stack : toolWithoutModifier) {
            if (!stack.m_150930_(slimeskull)) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStacks(ModifierRecipeCategory.getSlimeskullHelmets());
            break;
        }
        if ((focus = (IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).filter(f -> f.getRole() == RecipeIngredientRole.CATALYST).findFirst().orElse(null)) != null) {
            Item item = ((ItemStack)focus.getTypedValue().getIngredient()).m_41720_();
            for (ItemStack stack : toolWithoutModifier) {
                if (!stack.m_150930_(item)) continue;
                toolWithoutModifier = List.of(stack);
                break;
            }
            for (ItemStack stack : toolWithModifier) {
                if (!stack.m_150930_(item)) continue;
                toolWithModifier = List.of(stack);
                break;
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 25, 38).addItemStacks(toolWithoutModifier);
        builder.addSlot(RecipeIngredientRole.CATALYST, 105, 34).addItemStacks(toolWithModifier);
    }

    public static void clearSlimeskullCache() {
        SLIMESKULL_HELMETS = null;
    }

    private static List<ItemStack> getSlimeskullHelmets() {
        if (SLIMESKULL_HELMETS == null) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            IModifiable slimeskull = (IModifiable)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
            SLIMESKULL_HELMETS = registry.getAllMaterials().stream().filter(material -> registry.getMaterialStats(material.getIdentifier(), SkullStats.ID).isPresent()).map(material -> ToolBuildHandler.buildItemFromMaterials(slimeskull, MaterialNBT.of(material))).toList();
        }
        return SLIMESKULL_HELMETS;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

