/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.layout.LayoutSlot;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.tools.TinkerTools;

public class ToolBuildingCategory
implements IRecipeCategory<ToolBuildingRecipe> {
    private static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "tinkering.tool_building");
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable anvil;
    private final IDrawable slotBg;
    private final IDrawable slotBorder;
    private final IDrawable itemCover;
    private static final int WIDTH = 134;
    private static final int HEIGHT = 66;
    private static final int ITEM_SIZE = 16;

    public ToolBuildingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(((ModifiableItem)TinkerTools.pickaxe.get()).getRenderTool());
        this.background = guiHelper.createDrawable(BACKGROUND_LOC, 122, 77, 134, 66);
        this.slotBg = guiHelper.createDrawable(BACKGROUND_LOC, 144, 59, 18, 18);
        this.slotBorder = guiHelper.createDrawable(BACKGROUND_LOC, 162, 59, 18, 18);
        this.anvil = guiHelper.createDrawable(BACKGROUND_LOC, 128, 61, 16, 16);
        this.itemCover = guiHelper.createDrawable(BACKGROUND_LOC, 122, 77, 70, 60);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ToolBuildingRecipe recipe, IFocusGroup focuses) {
        ItemStack itemStack;
        List<List> partsAndExtras = Stream.concat(recipe.getAllToolParts().stream(), recipe.getExtraRequirements().stream().map(ingredient -> Arrays.asList(ingredient.m_43908_()))).toList();
        List<LayoutSlot> layoutSlots = recipe.getLayoutSlots();
        int missingSlots = partsAndExtras.size() - layoutSlots.size();
        if (missingSlots < 0) {
            partsAndExtras = new ArrayList<List>(partsAndExtras);
            for (int additionalItem = 0; additionalItem > missingSlots; --additionalItem) {
                partsAndExtras.add(List.of(ItemStack.f_41583_));
            }
        }
        for (int i = 0; i < layoutSlots.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, layoutSlots.get(i).getX() + -6, layoutSlots.get(i).getY() + -15).addItemStacks(partsAndExtras.get(i));
        }
        IModifiable iModifiable = recipe.getOutput();
        if (iModifiable instanceof IModifiableDisplay) {
            IModifiableDisplay modifiable = (IModifiableDisplay)iModifiable;
            itemStack = modifiable.getRenderTool();
        } else {
            itemStack = recipe.getOutput().m_5456_().m_7968_();
        }
        ItemStack outputStack = itemStack;
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 23).addItemStack(outputStack);
    }

    public void draw(ToolBuildingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ItemStack itemStack;
        IModifiable iModifiable = recipe.getOutput();
        if (iModifiable instanceof IModifiableDisplay) {
            IModifiableDisplay modifiable = (IModifiableDisplay)iModifiable;
            itemStack = modifiable.getRenderTool();
        } else {
            itemStack = recipe.getOutput().m_5456_().m_7968_();
        }
        ItemStack outputStack = itemStack;
        PoseStack renderPose = RenderSystem.m_157191_();
        renderPose.m_85836_();
        renderPose.m_166854_(stack.m_85850_().m_85861_());
        renderPose.m_85837_(5.0, 6.5, 0.0);
        renderPose.m_85841_(3.7f, 3.7f, 1.0f);
        Minecraft.m_91087_().m_91291_().m_115123_(outputStack, 0, 0);
        renderPose.m_85849_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.82f);
        this.itemCover.draw(stack, 5, 6);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        for (LayoutSlot layoutSlot : recipe.getLayoutSlots()) {
            this.slotBg.draw(stack, layoutSlot.getX() + -6 - 1, layoutSlot.getY() + -15 - 1);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (LayoutSlot layoutSlot : recipe.getLayoutSlots()) {
            this.slotBorder.draw(stack, layoutSlot.getX() + -6 - 1, layoutSlot.getY() + -15 - 1);
        }
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        if (recipe.requiresAnvil()) {
            this.anvil.draw(stack, 76, 44);
        }
    }

    public List<Component> getTooltipStrings(ToolBuildingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return recipe.requiresAnvil() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 76, 44, 16, 16) ? List.of(TConstruct.makeTranslation("jei", "tinkering.tool_building.anvil")) : List.of();
    }

    @Nonnull
    public Component getTitle() {
        return TITLE;
    }

    @Nonnull
    public RecipeType<ToolBuildingRecipe> getRecipeType() {
        return TConstructJEIConstants.TOOL_BUILDING;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }
}

