/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends Item
implements IMaterialItem {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(Item.Properties properties) {
        super(properties);
    }

    private static MaterialVariantId getMaterialId(@Nullable CompoundTag nbt) {
        MaterialVariantId id;
        String str;
        if (nbt != null && !(str = nbt.m_128461_("Material")).isEmpty() && (id = MaterialVariantId.tryParse(str)) != null) {
            return id;
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Override
    public MaterialVariantId getMaterial(ItemStack stack) {
        return MaterialItem.getMaterialId(stack.m_41783_());
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group) && MaterialRegistry.isFullyLoaded()) {
            MaterialVariantId materialId;
            String showOnlyId = (String)Config.COMMON.showOnlyPartMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialVariantId.tryParse(showOnlyId)) != null && this.canUseMaterial(materialId.getId())) {
                items.add((Object)this.withMaterialForDisplay(materialId));
                added = true;
            }
            if (!added) {
                for (IMaterial material : MaterialRegistry.getInstance().getVisibleMaterials()) {
                    MaterialId id = material.getIdentifier();
                    if (!this.canUseMaterial(id)) continue;
                    items.add((Object)this.withMaterial(id));
                    if (showOnlyId.isEmpty()) continue;
                    break;
                }
            }
        }
    }

    @Nullable
    private static Component getName(String baseKey, MaterialVariantId material) {
        ResourceLocation location = material.getLocation('.');
        String fullKey = String.format("%s.%s.%s", baseKey, location.m_135827_(), location.m_135815_());
        if (Util.canTranslate(fullKey)) {
            return Component.m_237115_((String)fullKey);
        }
        String materialKey = MaterialTooltipCache.getKey(material);
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return Component.m_237110_((String)materialPrefix, (Object[])new Object[]{Component.m_237115_((String)baseKey)});
        }
        if (Util.canTranslate(materialKey)) {
            return Component.m_237110_((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{Component.m_237115_((String)materialKey), Component.m_237115_((String)baseKey)});
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        Component component;
        MaterialVariantId material = this.getMaterial(stack);
        if (material.equals(IMaterial.UNKNOWN_ID)) {
            return super.m_7626_(stack);
        }
        String key = this.m_5671_(stack);
        if (material.hasVariant() && (component = MaterialItem.getName(key, material)) != null) {
            return component;
        }
        component = MaterialItem.getName(key, material.getId());
        if (component != null) {
            return component;
        }
        return Component.m_237115_((String)key);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        MaterialVariantId material = this.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            return material.getId().m_135827_();
        }
        return Registry.f_122827_.m_7981_((Object)this).m_135827_();
    }

    protected static void addModTooltip(IMaterial material, List<Component> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237110_((String)ADDED_BY, (Object[])new Object[]{DomainDisplayName.nameFor(material.getIdentifier().m_135827_())}));
        }
    }

    public void m_142312_(CompoundTag nbt) {
        MaterialId resolved;
        MaterialId original;
        MaterialVariantId id = MaterialItem.getMaterialId(nbt);
        if (!id.equals(IMaterial.UNKNOWN_ID) && (original = id.getId()) != (resolved = MaterialRegistry.getInstance().resolve(original))) {
            nbt.m_128359_("Material", MaterialVariantId.create(resolved, id.getVariant()).toString());
        }
    }
}

