/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.field.OptionallyNestedLoadable;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolStatsHook;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialTraitsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.StatScaleField;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ModifierBuilder;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public class MaterialStatsModule
implements ToolStatsHook,
ToolTraitHook,
ToolMaterialHook,
MaterialRepairToolHook,
ToolModule {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.TOOL_STATS, ToolHooks.TOOL_TRAITS, ToolHooks.TOOL_MATERIALS, ToolHooks.MATERIAL_REPAIR);
    protected static final LoadableField<Integer, MaterialStatsModule> PRIMARY_PART_FIELD = IntLoadable.FROM_MINUS_ONE.defaultField("primary_part", (Object)0, true, m -> m.primaryPart);
    public static final RecordLoadable<MaterialStatsModule> LOADER = RecordLoadable.create((RecordField)new OptionallyNestedLoadable<MaterialStatsId>((Loadable<MaterialStatsId>)MaterialStatsId.PARSER, "stat").list().requiredField("stat_types", m -> m.statTypes), (RecordField)new StatScaleField("stat", "stat_types"), PRIMARY_PART_FIELD, MaterialStatsModule::new);
    private final List<MaterialStatsId> statTypes;
    @VisibleForTesting
    final float[] scales;
    private int[] repairIndices;
    private final int primaryPart;

    @Deprecated
    public MaterialStatsModule(List<MaterialStatsId> statTypes, float[] scales) {
        this(statTypes, scales, 0);
    }

    protected MaterialStatsModule(List<MaterialStatsId> statTypes, float[] scales, int primaryPart) {
        this.statTypes = statTypes;
        this.scales = scales;
        this.primaryPart = primaryPart;
    }

    public RecordLoadable<? extends MaterialStatsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addModules(ModuleHookMap.Builder builder) {
        if (this.primaryPart >= 0 && this.primaryPart < this.statTypes.size()) {
            builder.addHook(new MaterialTraitsModule(this.statTypes.get(this.primaryPart), this.primaryPart), ToolHooks.REBALANCED_TRAIT);
        }
    }

    @Override
    public List<MaterialStatsId> getStatTypes(ToolDefinition definition) {
        return this.statTypes;
    }

    private int[] getRepairIndices() {
        if (this.repairIndices == null) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            this.repairIndices = IntStream.range(0, this.statTypes.size()).filter(i -> registry.canRepair(this.statTypes.get(i))).toArray();
        }
        return this.repairIndices;
    }

    @Override
    public boolean isRepairMaterial(IToolStackView tool, MaterialId material) {
        for (int part : this.getRepairIndices()) {
            if (!tool.getMaterial(part).matches(material)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getRepairAmount(IToolStackView tool, MaterialId material) {
        ResourceLocation toolId = tool.getDefinition().getId();
        for (int i : this.getRepairIndices()) {
            if (!tool.getMaterial(i).matches(material)) continue;
            return MaterialRepairModule.getDurability(toolId, material, this.statTypes.get(i));
        }
        return 0.0f;
    }

    @Override
    public void addToolStats(IToolContext context, ModifierStatsBuilder builder) {
        MaterialNBT materials = context.getMaterials();
        if (materials.size() > 0) {
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            for (int i = 0; i < this.statTypes.size(); ++i) {
                MaterialStatsId statType = this.statTypes.get(i);
                Optional stats = registry.getMaterialStats(materials.get(i).getId(), statType);
                if (stats.isPresent()) {
                    ((IMaterialStats)stats.get()).apply(builder, this.scales[i]);
                    continue;
                }
                Object defaultStats = registry.getDefaultStats(statType);
                if (defaultStats == null) continue;
                defaultStats.apply(builder, this.scales[i]);
            }
        }
    }

    @Override
    public void addTraits(ToolDefinition definition, MaterialNBT materials, ModifierBuilder builder) {
        int max = Math.min(materials.size(), this.statTypes.size());
        if (max > 0) {
            IMaterialRegistry materialRegistry = MaterialRegistry.getInstance();
            for (int i = 0; i < max; ++i) {
                builder.add(materialRegistry.getTraits(materials.get(i).getId(), this.statTypes.get(i)));
            }
        }
    }

    public static Builder stats() {
        return new Builder();
    }

    public float[] getScales() {
        return this.scales;
    }

    public static class Builder {
        private final ImmutableList.Builder<MaterialStatsId> stats = ImmutableList.builder();
        private final ImmutableList.Builder<Float> scales = ImmutableList.builder();
        private int primaryPart = 0;

        public Builder stat(MaterialStatsId stat, float scale) {
            this.stats.add((Object)stat);
            this.scales.add((Object)Float.valueOf(scale));
            return this;
        }

        public Builder stat(MaterialStatsId stat) {
            return this.stat(stat, 1.0f);
        }

        static float[] buildScales(List<Float> list) {
            float[] scales = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                scales[i] = list.get(i).floatValue();
            }
            return scales;
        }

        public MaterialStatsModule build() {
            ImmutableList stats = this.stats.build();
            if (this.primaryPart >= stats.size() || this.primaryPart < -1) {
                throw new IllegalStateException("Primary part must be within parts list, maximum " + stats.size() + ", got " + this.primaryPart);
            }
            return new MaterialStatsModule((List<MaterialStatsId>)stats, Builder.buildScales((List<Float>)this.scales.build()), this.primaryPart);
        }

        private Builder() {
        }

        public Builder primaryPart(int primaryPart) {
            this.primaryPart = primaryPart;
            return this;
        }
    }
}

