/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.molding.IMoldingContainer;

public class MoldingRecipe
implements ICommonRecipe<IMoldingContainer> {
    public static final RecordLoadable<MoldingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("material", MoldingRecipe::getMaterial), (RecordField)IngredientLoadable.ALLOW_EMPTY.defaultField("pattern", (Object)Ingredient.f_43901_, MoldingRecipe::getPattern), (RecordField)BooleanLoadable.INSTANCE.defaultField("pattern_consumed", (Object)false, false, MoldingRecipe::isPatternConsumed), (RecordField)ItemOutput.Loadable.REQUIRED_ITEM.requiredField("result", r -> r.recipeOutput), MoldingRecipe::new);
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    private final ResourceLocation id;
    private final Ingredient material;
    private final Ingredient pattern;
    private final boolean patternConsumed;
    private final ItemOutput recipeOutput;

    public MoldingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, Ingredient material, Ingredient pattern, boolean patternConsumed, ItemOutput recipeOutput) {
        this.type = serializer.getType();
        this.serializer = serializer;
        this.id = id;
        this.material = material;
        this.pattern = pattern;
        this.patternConsumed = pattern != Ingredient.f_43901_ && patternConsumed;
        this.recipeOutput = recipeOutput;
    }

    public boolean matches(IMoldingContainer inv, Level worldIn) {
        return this.material.test(inv.getMaterial()) && this.pattern.test(inv.getPattern());
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.material, this.pattern});
    }

    public ItemStack m_8043_() {
        return this.recipeOutput.get();
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Ingredient getPattern() {
        return this.pattern;
    }

    public boolean isPatternConsumed() {
        return this.patternConsumed;
    }
}

