/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.armor;

import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public interface OnAttackedModifierHook {
    public void onAttacked(IToolStackView var1, ModifierEntry var2, EquipmentContext var3, EquipmentSlot var4, DamageSource var5, float var6, boolean var7);

    public static boolean isDirectDamage(DamageSource source) {
        EntityDamageSource entityDamage;
        return source.m_7639_() != null && source instanceof EntityDamageSource && !(entityDamage = (EntityDamageSource)source).m_19403_();
    }

    private static void handleAttack(ModuleHook<OnAttackedModifierHook> hook, EquipmentContext context, DamageSource source, float amount, boolean isDirectDamage, EquipmentSlot slotType) {
        IToolStackView toolStack = context.getToolInSlot(slotType);
        if (toolStack != null && !toolStack.isBroken()) {
            for (ModifierEntry entry : toolStack.getModifierList()) {
                entry.getHook(hook).onAttacked(toolStack, entry, context, slotType, source, amount, isDirectDamage);
            }
        }
    }

    public static void handleAttack(ModuleHook<OnAttackedModifierHook> hook, EquipmentContext context, DamageSource source, float amount, boolean isDirectDamage) {
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            OnAttackedModifierHook.handleAttack(hook, context, source, amount, isDirectDamage, slotType);
        }
        LivingEntity entity = context.getEntity();
        if (entity.m_21254_()) {
            OnAttackedModifierHook.handleAttack(hook, context, source, amount, isDirectDamage, Util.getSlotType(entity.m_7655_()));
        }
    }

    public record AllMerger(Collection<OnAttackedModifierHook> modules) implements OnAttackedModifierHook
    {
        @Override
        public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
            for (OnAttackedModifierHook module : this.modules) {
                module.onAttacked(tool, modifier, context, slotType, source, amount, isDirectDamage);
            }
        }
    }
}

