/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class TableModel
implements IUnbakedGeometry<TableModel> {
    public static final IGeometryLoader<TableModel> LOADER = TableModel::deserialize;
    private final SimpleBlockModel model;
    private final Set<String> retextured;
    private final List<ModelItem> items;

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getMaterials(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bake(owner, bakery, spriteGetter, transform, overrides, location);
        return new Baked(baked, owner, this.model, transform, RetexturedModel.getAllRetextured((IGeometryBakingContext)owner, (SimpleBlockModel)this.model, this.retextured), this.items);
    }

    public static TableModel deserialize(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        Set retextured = RetexturedModel.getRetexturedNames((JsonObject)json);
        List items = ModelItem.listFromJson((JsonObject)json, (String)"items");
        return new TableModel(model, retextured, items);
    }

    public TableModel(SimpleBlockModel model, Set<String> retextured, List<ModelItem> items) {
        this.model = model;
        this.retextured = retextured;
        this.items = items;
    }

    public static class Baked
    extends RetexturedModel.Baked {
        private final List<ModelItem> items;

        protected Baked(BakedModel baked, IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, Set<String> retextured, List<ModelItem> items) {
            super(baked, owner, model, transform, retextured);
            this.items = items;
        }

        public List<ModelItem> getItems() {
            return this.items;
        }
    }
}

