/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerUpper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.data.GenericNBTProvider;

public class StructureUpdater
extends GenericNBTProvider {
    private final String basePath;
    private final String modId;
    private final MultiPackResourceManager resources;

    public StructureUpdater(DataGenerator generator, ExistingFileHelper helper, String modId, PackType packType, String basePath) {
        super(generator, packType, basePath);
        this.modId = modId;
        this.basePath = basePath;
        try {
            Field resourceManager = ExistingFileHelper.class.getDeclaredField(packType == PackType.SERVER_DATA ? "serverData" : "clientResources");
            resourceManager.setAccessible(true);
            this.resources = (MultiPackResourceManager)resourceManager.get(helper);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void m_213708_(CachedOutput cache) {
        for (Map.Entry entry : this.resources.m_214159_(this.basePath, file -> file.m_135827_().equals(this.modId) && file.m_135815_().endsWith(".nbt")).entrySet()) {
            this.process(this.localize((ResourceLocation)entry.getKey()), (Resource)entry.getValue(), cache);
        }
    }

    private void process(ResourceLocation location, Resource resource, CachedOutput cache) {
        try {
            CompoundTag inputNBT = NbtIo.m_128939_((InputStream)resource.m_215507_());
            CompoundTag converted = StructureUpdater.updateNBT(inputNBT);
            if (!converted.equals((Object)inputNBT)) {
                Class<?> fixerClass = DataFixers.m_14512_().getClass();
                if (!fixerClass.equals(DataFixerUpper.class)) {
                    throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
                }
                this.saveNBT(cache, location, converted);
            }
        }
        catch (IOException e) {
            TConstruct.LOG.error("Couldn't read NBT for {}", (Object)location, (Object)e);
        }
    }

    private static CompoundTag updateNBT(CompoundTag nbt) {
        CompoundTag updatedNBT = NbtUtils.m_129213_((DataFixer)DataFixers.m_14512_(), (DataFixTypes)DataFixTypes.STRUCTURE, (CompoundTag)nbt, (int)nbt.m_128451_("DataVersion"));
        StructureTemplate template = new StructureTemplate();
        template.m_74638_(updatedNBT);
        return template.m_74618_(new CompoundTag());
    }

    public String m_6055_() {
        return "Update structure files in " + this.basePath;
    }
}

