/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.client.ForgeHooksClient;

public class SlimeArmorLayer<T extends Slime, M extends HierarchicalModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final A armorModel;
    public final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final boolean lavaSlime;

    public SlimeArmorLayer(RenderLayerParent<T, M> pRenderer, A armorModel, EntityModelSet modelSet, boolean lavaSlime) {
        super(pRenderer);
        this.armorModel = armorModel;
        this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)modelSet);
        this.lavaSlime = lavaSlime;
    }

    public void render(PoseStack matrices, MultiBufferSource buffer, int packedLight, T entity, float pLimbSwing, float swing, float partialTicks, float age, float headYaw, float headPitch) {
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_()) {
            BlockItem block;
            Block dyeable2;
            ArmorItem armor;
            matrices.m_85836_();
            if (this.lavaSlime) {
                float squish = Mth.m_14179_((float)partialTicks, (float)((Slime)entity).f_33585_, (float)((Slime)entity).f_33584_);
                if (squish < 0.0f) {
                    squish = 0.0f;
                }
                matrices.m_85837_(0.0, 1.5 - 0.425 * (double)squish, 0.0);
            } else {
                matrices.m_85837_(0.0, 1.5, 0.0);
            }
            matrices.m_85841_(0.9f, 0.9f, 0.9f);
            Item item = helmet.m_41720_();
            if (item instanceof ArmorItem && (armor = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD) {
                ((HierarchicalModel)this.m_117386_()).m_102624_(this.armorModel);
                this.armorModel.m_8009_(false);
                ((HumanoidModel)this.armorModel).f_102808_.f_104207_ = true;
                ((HumanoidModel)this.armorModel).f_102809_.f_104207_ = true;
                Model model = ForgeHooksClient.getArmorModel(entity, (ItemStack)helmet, (EquipmentSlot)EquipmentSlot.HEAD, this.armorModel);
                boolean enchanted = helmet.m_41790_();
                if (armor instanceof DyeableLeatherItem) {
                    DyeableLeatherItem dyeable2 = (DyeableLeatherItem)armor;
                    int color = dyeable2.m_41121_(helmet);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    SlimeArmorLayer.renderModel(matrices, buffer, packedLight, enchanted, model, red, green, blue, SlimeArmorLayer.getArmorResource(entity, helmet, armor, ""));
                    SlimeArmorLayer.renderModel(matrices, buffer, packedLight, enchanted, model, 1.0f, 1.0f, 1.0f, SlimeArmorLayer.getArmorResource(entity, helmet, armor, "_overlay"));
                } else {
                    SlimeArmorLayer.renderModel(matrices, buffer, packedLight, enchanted, model, 1.0f, 1.0f, 1.0f, SlimeArmorLayer.getArmorResource(entity, helmet, armor, ""));
                }
            } else if (item instanceof BlockItem && (dyeable2 = (block = (BlockItem)item).m_40614_()) instanceof AbstractSkullBlock) {
                AbstractSkullBlock skullBlock = (AbstractSkullBlock)dyeable2;
                matrices.m_85841_(1.1875f, -1.1875f, -1.1875f);
                GameProfile gameprofile = null;
                CompoundTag tag = helmet.m_41783_();
                if (tag != null && tag.m_128425_("SkullOwner", 10)) {
                    gameprofile = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("SkullOwner"));
                }
                matrices.m_85837_(-0.5, 0.0, -0.5);
                SkullBlock.Type type = skullBlock.m_48754_();
                SkullModelBase skullModel = this.skullModels.get(type);
                RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)gameprofile);
                SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)pLimbSwing, (PoseStack)matrices, (MultiBufferSource)buffer, (int)packedLight, (SkullModelBase)skullModel, (RenderType)renderType);
            } else {
                CustomHeadLayer.m_174483_((PoseStack)matrices, (boolean)false);
                Minecraft.m_91087_().m_91290_().m_234586_().m_109322_(entity, helmet, ItemTransforms.TransformType.HEAD, false, matrices, buffer, packedLight);
            }
            matrices.m_85849_();
        }
    }

    private static void renderModel(PoseStack matrices, MultiBufferSource buffer, int packedLight, boolean enchanted, Model model, float red, float green, float blue, ResourceLocation texture) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)enchanted);
        model.m_7695_(matrices, vertexconsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, ArmorItem armor, String type) {
        String texture = armor.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String path = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_1%s.png", domain, texture, type);
        ResourceLocation location = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(path = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)path, (EquipmentSlot)EquipmentSlot.HEAD, (String)type));
        if (location == null) {
            location = new ResourceLocation(path);
            HumanoidArmorLayer.f_117070_.put(path, location);
        }
        return location;
    }
}

