/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;

public class BouncyModifier
extends NoLevelsModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BOUNCY = TConstruct.createKey("bouncy");

    public BouncyModifier() {
        MinecraftForge.EVENT_BUS.addListener(BouncyModifier::onFall);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(new ArmorLevelModule(BOUNCY, false, null));
    }

    private static void onFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living == null || living.m_20184_().f_82480_ > -0.3 && living.f_19789_ < 3.0f) {
            return;
        }
        if (ArmorLevelModule.getLevel(living, BOUNCY) == 0) {
            return;
        }
        if (living.m_20162_()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        Vec3 motion = living.m_20184_();
        if (living instanceof ServerPlayer) {
            double gravity = living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double time = Math.sqrt((double)living.f_19789_ / gravity);
            double velocity = gravity * time;
            living.m_20334_(motion.f_82479_ / (double)0.975f, velocity, motion.f_82481_ / (double)0.975f);
            living.f_19864_ = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            float factor = living.f_19789_ < 2.0f ? -0.7f : -0.9f;
            living.m_20334_(motion.f_82479_ / (double)0.975f, motion.f_82480_ * (double)factor, motion.f_82481_ / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living, living.m_20184_());
        }
        event.setDistance(0.0f);
        if (!living.f_19853_.f_46443_) {
            living.f_19812_ = true;
            event.setCanceled(true);
            living.m_6853_(false);
        }
        living.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
    }
}

