/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.aoe;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface AreaOfEffectIterator {
    public static final GenericLoaderRegistry<Loadable> LOADER = new GenericLoaderRegistry("AOE Iterator", false);

    public static void register(ResourceLocation name, GenericLoaderRegistry.IGenericLoader<? extends Loadable> loader) {
        ToolModule.LOADER.register(name, loader);
        LOADER.register(name, loader);
    }

    public Iterable<BlockPos> getBlocks(IToolStackView var1, ItemStack var2, Player var3, BlockState var4, Level var5, BlockPos var6, Direction var7, AOEMatchType var8);

    public static Predicate<BlockPos> defaultBlockPredicate(IToolStackView tool, ItemStack stack, Level world, BlockPos origin, AOEMatchType matchType) {
        if (matchType == AOEMatchType.BREAKING) {
            float refHardness = world.m_8055_(origin).m_60800_((BlockGetter)world, origin);
            return pos -> {
                BlockState state = world.m_8055_(pos);
                if (state.m_60795_()) {
                    return false;
                }
                float hardness = state.m_60800_((BlockGetter)world, pos);
                if (hardness == -1.0f) {
                    return false;
                }
                if (refHardness == 0.0f ? hardness == 0.0f : hardness / refHardness <= 3.0f) {
                    return IsEffectiveToolHook.isEffective(tool, state);
                }
                return false;
            };
        }
        return pos -> !world.m_46859_(pos);
    }

    public static enum AOEMatchType {
        BREAKING,
        TRANSFORM;

    }

    public static interface Loadable
    extends AreaOfEffectIterator,
    ToolModule {
        public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.AOE_ITERATOR);

        @Override
        default public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }
    }
}

