/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.mining;

import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface BlockHarvestModifierHook {
    default public void startHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
    }

    default public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
        this.finishHarvest(tool, modifier, context, harvested > 0);
    }

    @Deprecated
    public void finishHarvest(IToolStackView var1, ModifierEntry var2, ToolHarvestContext var3, boolean var4);

    public static interface MarkHarvesting
    extends BlockHarvestModifierHook {
        public static final ResourceLocation HARVESTING_FLAG = TConstruct.getResource("is_harvesting");

        @Override
        default public void startHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
            tool.getPersistentData().putBoolean(HARVESTING_FLAG, true);
        }

        @Override
        default public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, boolean didHarvest) {
            tool.getPersistentData().remove(HARVESTING_FLAG);
        }

        public static boolean isHarvesting(IToolStackView tool) {
            return tool.getPersistentData().getBoolean(HARVESTING_FLAG);
        }
    }

    public record AllMerger(Collection<BlockHarvestModifierHook> modules) implements BlockHarvestModifierHook
    {
        @Override
        public void startHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
            for (BlockHarvestModifierHook module : this.modules) {
                module.startHarvest(tool, modifier, context);
            }
        }

        @Override
        public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
            for (BlockHarvestModifierHook module : this.modules) {
                module.finishHarvest(tool, modifier, context, harvested);
            }
        }

        @Override
        public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, boolean didHarvest) {
            for (BlockHarvestModifierHook module : this.modules) {
                module.finishHarvest(tool, modifier, context, didHarvest);
            }
        }
    }
}

