/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public class VariableLoaderRegistry<T extends GenericLoaderRegistry.IHaveLoader>
extends GenericLoaderRegistry<T> {
    private final FloatFunction<? extends T> constantConstructor;
    private static final LoadableField<Float, ConstantFloat> VALUE_FIELD = FloatLoadable.ANY.requiredField("value", ConstantFloat::value);

    public VariableLoaderRegistry(String name, FloatFunction<? extends T> constantConstructor) {
        super(name, true);
        this.constantConstructor = constantConstructor;
    }

    public T convert(JsonElement element, String key) throws JsonSyntaxException {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isNumber()) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.constantConstructor.apply(primitive.getAsFloat()));
        }
        return (T)super.convert(element, key);
    }

    public JsonElement serialize(T src) {
        if (src instanceof ConstantFloat) {
            ConstantFloat constant = (ConstantFloat)src;
            return new JsonPrimitive((Number)Float.valueOf(constant.value()));
        }
        return super.serialize(src);
    }

    public T decode(FriendlyByteBuf buffer) {
        return (T)super.decode(buffer);
    }

    public static <T extends ConstantFloat & GenericLoaderRegistry.IHaveLoader> RecordLoadable<T> constantLoader(Function<Float, T> constructor) {
        return RecordLoadable.create(VALUE_FIELD, constructor);
    }

    public static interface FloatFunction<T> {
        public T apply(float var1);
    }

    public static interface ConstantFloat {
        public float value();
    }
}

