/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.ExtraTextureContext;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.BakedUniqueGuiModel;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.client.model.block.IncrementalFluidCuboid;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankModel
implements IUnbakedGeometry<TankModel> {
    protected static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("dynamic_model_baking");
    public static final IGeometryLoader<TankModel> LOADER = TankModel::deserialize;
    protected final SimpleBlockModel model;
    @Nullable
    protected final SimpleBlockModel gui;
    protected final IncrementalFluidCuboid fluid;
    protected final boolean forceModelFluid;

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>(this.model.getMaterials(owner, modelGetter, missingTextureErrors));
        if (this.gui != null) {
            textures.addAll(this.gui.getMaterials(owner, modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked;
        BakedModel bakedGui = baked = this.model.bake(owner, bakery, spriteGetter, transform, overrides, location);
        if (this.gui != null) {
            bakedGui = this.gui.bake(owner, bakery, spriteGetter, transform, overrides, location);
        }
        return new Baked<TankModel>(owner, transform, baked, bakedGui, this);
    }

    public static TankModel deserialize(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        SimpleBlockModel gui = null;
        if (json.has("gui")) {
            gui = SimpleBlockModel.deserialize((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"gui"), (JsonDeserializationContext)context);
        }
        IncrementalFluidCuboid fluid = IncrementalFluidCuboid.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        boolean forceModelFluid = GsonHelper.m_13855_((JsonObject)json, (String)"render_fluid_in_model", (boolean)false);
        return new TankModel(model, gui, fluid, forceModelFluid);
    }

    public TankModel(SimpleBlockModel model, @Nullable SimpleBlockModel gui, IncrementalFluidCuboid fluid, boolean forceModelFluid) {
        this.model = model;
        this.gui = gui;
        this.fluid = fluid;
        this.forceModelFluid = forceModelFluid;
    }

    public static class Baked<T extends TankModel>
    extends BakedUniqueGuiModel {
        private final IGeometryBakingContext owner;
        private final ModelState originalTransforms;
        protected final T original;
        private final FluidPartOverride overrides = new FluidPartOverride();
        private final Cache<FluidStack, BakedModel> cache = CacheBuilder.newBuilder().maximumSize(64L).build();

        protected Baked(IGeometryBakingContext owner, ModelState transforms, BakedModel baked, BakedModel gui, T original) {
            super(baked, gui);
            this.owner = owner;
            this.originalTransforms = transforms;
            this.original = original;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        private BakedModel bakeWithFluid(IGeometryBakingContext owner, SimpleBlockModel baseModel, BlockElement fluid, int color, int luminosity) {
            Function<Material, TextureAtlasSprite> spriteGetter = Material::m_119204_;
            TextureAtlasSprite particle = spriteGetter.apply(owner.getMaterial("particle"));
            SimpleBakedModel.Builder builder = SimpleBlockModel.bakedBuilder((IGeometryBakingContext)owner, (ItemOverrides)ItemOverrides.f_111734_).m_119528_(particle);
            IQuadTransformer quadTransformer = SimpleBlockModel.applyTransform((ModelState)this.originalTransforms, (Transformation)owner.getRootTransform());
            for (BlockElement element : baseModel.getElements()) {
                SimpleBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)owner, (BlockElement)element, spriteGetter, (ModelState)this.originalTransforms, (IQuadTransformer)quadTransformer, (ResourceLocation)BAKE_LOCATION);
            }
            IQuadTransformer fluidTransformer = color == -1 ? quadTransformer : quadTransformer.andThen(ColoredBlockModel.applyColorQuadTransformer((int)color));
            ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IGeometryBakingContext)owner, (BlockElement)fluid, (int)luminosity, spriteGetter, (Transformation)this.originalTransforms.m_6189_(), (IQuadTransformer)fluidTransformer, (boolean)this.originalTransforms.m_7538_(), (ResourceLocation)BAKE_LOCATION);
            return builder.build(SimpleBlockModel.getRenderTypeGroup((IGeometryBakingContext)owner));
        }

        private BakedModel getModel(FluidStack stack) {
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
            FluidType type = stack.getFluid().getFluidType();
            int color = attributes.getTintColor(stack);
            int luminosity = type.getLightLevel(stack);
            ImmutableMap textures = ImmutableMap.of((Object)"fluid", (Object)new Material(InventoryMenu.f_39692_, attributes.getStillTexture(stack)), (Object)"flowing_fluid", (Object)new Material(InventoryMenu.f_39692_, attributes.getFlowingTexture(stack)));
            ExtraTextureContext textured = new ExtraTextureContext(this.owner, (Map)textures);
            BlockElement fluid = ((TankModel)this.original).fluid.getPart(stack.getAmount(), type.isLighterThanAir());
            Object baked = this.bakeWithFluid((IGeometryBakingContext)textured, ((TankModel)this.original).model, fluid, color, luminosity);
            if (((TankModel)this.original).gui != null) {
                baked = new BakedUniqueGuiModel((BakedModel)baked, this.bakeWithFluid((IGeometryBakingContext)textured, ((TankModel)this.original).gui, fluid, color, 0));
            }
            return baked;
        }

        private BakedModel getCachedModel(FluidStack fluid) {
            try {
                return (BakedModel)this.cache.get((Object)fluid, () -> this.getModel(fluid));
            }
            catch (ExecutionException e) {
                TConstruct.LOG.error((Object)e);
                return this;
            }
        }

        private BakedModel getCachedModel(FluidStack fluid, int capacity) {
            int increments = ((TankModel)this.original).fluid.getIncrements();
            return this.getCachedModel(new FluidStack(fluid, Mth.m_14045_((int)(fluid.getAmount() * increments / capacity), (int)1, (int)increments)));
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
            IFluidTank tank;
            if ((((TankModel)this.original).forceModelFluid || ((Boolean)Config.CLIENT.tankFluidModel.get()).booleanValue()) && data.has(ModelProperties.FLUID_TANK) && (tank = (IFluidTank)data.get(ModelProperties.FLUID_TANK)) != null && !tank.getFluid().isEmpty()) {
                return this.getCachedModel(tank.getFluid(), tank.getCapacity()).getQuads(state, side, rand, ModelData.EMPTY, renderType);
            }
            return this.originalModel.getQuads(state, side, rand, data, renderType);
        }

        public IncrementalFluidCuboid getFluid() {
            return ((TankModel)this.original).fluid;
        }

        private class FluidPartOverride
        extends ItemOverrides {
            private FluidPartOverride() {
            }

            public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
                if (stack.m_41619_() || !stack.m_41782_()) {
                    return model;
                }
                FluidTank tank = TankItem.getFluidTank(stack);
                if (tank.isEmpty()) {
                    return model;
                }
                return Baked.this.getCachedModel(tank.getFluid(), tank.getCapacity());
            }
        }
    }
}

