/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.OnDatapackSyncEvent;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.network.TinkerNetwork;

public class JsonUtils {
    private JsonUtils() {
    }

    @Deprecated(forRemoval=true)
    public static int getIntMin(JsonObject json, String key, int min) {
        int value = GsonHelper.m_13824_((JsonObject)json, (String)key, (int)min);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    @Deprecated(forRemoval=true)
    public static int convertToIntMin(JsonElement json, String key, int min) {
        int value = GsonHelper.m_13897_((JsonElement)json, (String)key);
        if (value < min) {
            throw new JsonSyntaxException(key + " must be at least " + min);
        }
        return value;
    }

    public static void syncPackets(OnDatapackSyncEvent event, ISimplePacket ... packets) {
        JsonHelper.syncPackets((OnDatapackSyncEvent)event, (NetworkWrapper)TinkerNetwork.getInstance(), (ISimplePacket[])packets);
    }

    public static JsonObject withLocation(String key, ResourceLocation value) {
        JsonObject json = new JsonObject();
        json.addProperty(key, value.toString());
        return json;
    }

    public static JsonObject withType(ResourceLocation type) {
        return JsonUtils.withLocation("type", type);
    }

    @Deprecated(forRemoval=true)
    public static ItemStack convertToItemStack(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return new ItemStack((ItemLike)GsonHelper.m_13874_((JsonElement)element, (String)name));
        }
        return CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)name), (boolean)true);
    }

    @Deprecated(forRemoval=true)
    public static ItemStack getAsItemStack(JsonObject parent, String name) {
        return JsonUtils.convertToItemStack(JsonHelper.getElement((JsonObject)parent, (String)name), name);
    }

    @Deprecated(forRemoval=true)
    public static JsonElement serializeItemStack(ItemStack result) {
        String itemName = Registry.f_122827_.m_7981_((Object)result.m_41720_()).toString();
        if (result.m_41782_()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.m_41613_();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.m_41783_()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }

    @Deprecated(forRemoval=true)
    public static int parseColor(@Nullable String color) {
        if (color == null || color.isEmpty()) {
            return -1;
        }
        return (Integer)ColorLoadable.NO_ALPHA.parseString(color, "[unknown]");
    }

    @Deprecated(forRemoval=true)
    public static String colorToString(int color) {
        return ColorLoadable.NO_ALPHA.getString((Object)color);
    }
}

