/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class LazyToolStack {
    @Nullable
    private ItemStack stack;
    @Nullable
    private ToolStack tool;
    private final int size;

    public static LazyToolStack from(ItemStack stack) {
        return new LazyToolStack(stack, null, stack.m_41613_());
    }

    public static LazyToolStack from(ToolStack tool, int count) {
        return new LazyToolStack(null, tool, count);
    }

    public static LazyToolStack from(ToolStack tool) {
        return LazyToolStack.from(tool, 1);
    }

    public ToolStack getTool() {
        if (this.tool == null) {
            assert (this.stack != null);
            this.tool = ToolStack.from(this.stack);
        }
        return this.tool;
    }

    public ItemStack getStack() {
        if (this.stack == null) {
            assert (this.tool != null);
            this.stack = this.tool.createStack(this.size);
        }
        return this.stack;
    }

    private LazyToolStack(@Nullable ItemStack stack, @Nullable ToolStack tool, int size) {
        this.stack = stack;
        this.tool = tool;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

