/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.nbt.DummyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootingHandler {
    private static final Map<UUID, EquipmentSlot> LOOTING_OFFHAND = new HashMap<UUID, EquipmentSlot>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ModifierLootingHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLeaveServer);
    }

    public static void setLootingSlot(LivingEntity entity, EquipmentSlot slotType) {
        if (slotType == EquipmentSlot.MAINHAND) {
            LOOTING_OFFHAND.remove(entity.m_20148_());
        } else {
            LOOTING_OFFHAND.put(entity.m_20148_(), slotType);
        }
    }

    public static EquipmentSlot getLootingSlot(@Nullable LivingEntity entity) {
        return entity != null ? LOOTING_OFFHAND.getOrDefault(entity.m_20148_(), EquipmentSlot.MAINHAND) : EquipmentSlot.MAINHAND;
    }

    private static void onLooting(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.m_7639_();
        if (source instanceof LivingEntity) {
            LootingContext context;
            LivingEntity holder = (LivingEntity)source;
            Entity direct = damageSource.m_7640_();
            int level = event.getLootingLevel();
            LivingEntity target = event.getEntity();
            ToolStack tool = null;
            if (direct instanceof Projectile) {
                ModifierNBT modifiers = EntityModifierCapability.getOrEmpty(direct);
                context = new LootingContext(holder, target, damageSource, null);
                if (!modifiers.isEmpty()) {
                    ModDataNBT persistentData = direct.getCapability(PersistentDataCapability.CAPABILITY).map(ModDataNBT::new).orElseGet(ModDataNBT::new);
                    level = LootingModifierHook.getLooting(new DummyToolStack(Items.f_41852_, modifiers, persistentData), context, 0);
                }
            } else {
                EquipmentSlot slotType = ModifierLootingHandler.getLootingSlot(holder);
                context = new LootingContext(holder, target, damageSource, slotType);
                ItemStack held = holder.m_6844_(slotType);
                if (held.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                    tool = ToolStack.from(held);
                    level = LootingModifierHook.getLooting(tool, context, level);
                } else if (slotType != EquipmentSlot.MAINHAND) {
                    level = 0;
                }
            }
            level = ArmorLootingModifierHook.getLooting(tool, context, level);
            event.setLootingLevel(Math.max(level, 0));
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        LOOTING_OFFHAND.remove(event.getEntity().m_20148_());
    }
}

