/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.NamedComponentRegistry;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.field.MergingField;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipe
extends ModifierRecipe {
    private static final String ALREADY_PRESENT = TConstruct.makeTranslationKey("recipe", "swappable.already_present");
    public static final RecordLoadable<SwappableModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)INPUTS_FIELD, (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, new MergingField(ModifierId.PARSER.requiredField("name", r -> r.result.getId()), "result", MergingField.MissingMode.DISALLOWED), new MergingField(StringLoadable.DEFAULT.requiredField("value", r -> r.value), "result", MergingField.MissingMode.DISALLOWED), (RecordField)VariantFormatter.LOADER.defaultField("variant_formatter", (Object)VariantFormatter.DEFAULT, r -> r.variantFormatter), (RecordField)SLOTS_FIELD, (RecordField)ALLOW_CRYSTAL_FIELD, SwappableModifierRecipe::new);
    private final String value;
    private final VariantFormatter variantFormatter;
    private final Component variant;

    @Deprecated
    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierId result, String value, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        this(id, inputs, toolRequirement, maxToolSize, result, value, VariantFormatter.DEFAULT, slots, allowCrystal);
    }

    public SwappableModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierId result, String value, VariantFormatter variantFormatter, @Nullable SlotType.SlotCount slots, boolean allowCrystal) {
        super(id, inputs, toolRequirement, maxToolSize, result, new IntRange(1, 1), slots, allowCrystal, false);
        this.value = value;
        this.variantFormatter = variantFormatter;
        this.variant = variantFormatter.format(result, value);
    }

    @Override
    public RecipeResult<ItemStack> getValidatedResult(ITinkerStationContainer inv) {
        SlotType.SlotCount slots;
        boolean needsModifier;
        ToolStack tool = inv.getTinkerable();
        ModifierId modifier = this.result.getId();
        if (tool.getUpgrades().getLevel(modifier) == 0) {
            needsModifier = true;
            Component commonError = this.validatePrerequisites(tool);
            if (commonError != null) {
                return RecipeResult.failure(commonError);
            }
        } else {
            needsModifier = false;
        }
        if (tool.getPersistentData().getString(modifier).equals(this.value)) {
            return RecipeResult.failure(ALREADY_PRESENT, this.result.get().getDisplayName(), this.variant);
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (needsModifier && (slots = this.getSlots()) != null) {
            persistentData.addSlots(slots.type(), -slots.count());
        }
        persistentData.putString(modifier, this.value);
        if (needsModifier) {
            tool.addModifier(this.result.getId(), 1);
        } else {
            tool.rebuildStats();
        }
        Component toolValidation = tool.tryValidate();
        if (toolValidation != null) {
            return RecipeResult.failure(toolValidation);
        }
        return RecipeResult.success(tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())));
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            ModifierId id = this.result.getId();
            ModifierEntry result = this.getDisplayResult();
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, IDisplayModifierRecipe.modifiersForResult(result, result), data -> data.putString(id, this.value))).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public Component getVariant() {
        return this.variant;
    }

    @FunctionalInterface
    public static interface VariantFormatter {
        public static final NamedComponentRegistry<VariantFormatter> LOADER = new NamedComponentRegistry("Unknown variant formatter");
        public static final VariantFormatter DEFAULT = (VariantFormatter)LOADER.register(TConstruct.getResource("default"), (modifier, variant) -> Component.m_237115_((String)(Util.makeTranslationKey("modifier", modifier) + "." + variant)));
        public static final VariantFormatter MATERIAL = (VariantFormatter)LOADER.register(TConstruct.getResource("material"), (modifier, variant) -> MaterialTooltipCache.getDisplayName(Objects.requireNonNullElse(MaterialVariantId.tryParse(variant), IMaterial.UNKNOWN_ID)));

        public Component format(ModifierId var1, String var2);
    }
}

