/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.recipe.helper.ItemOutput;

public abstract class RandomItem {
    public static RandomItem range(ItemOutput result, int minCount) {
        return new Range(result, minCount);
    }

    public static RandomItem range(ItemOutput result) {
        return RandomItem.range(result, 0);
    }

    public static RandomItem chance(ItemOutput result, float chance) {
        return new Chance(result, chance);
    }

    public static RandomItem constant(ItemOutput result) {
        return RandomItem.chance(result, 1.0f);
    }

    public abstract ItemStack get(Random var1);

    public abstract JsonElement serialize();

    public abstract void write(FriendlyByteBuf var1);

    public static RandomItem fromJson(JsonElement element, String name) {
        JsonObject object;
        if (element.isJsonObject() && (object = element.getAsJsonObject()).has("max")) {
            object.addProperty("count", (Number)GsonHelper.m_13927_((JsonObject)object, (String)"max"));
            object.remove("max");
        }
        ItemOutput result = ItemOutput.Loadable.REQUIRED_STACK.convert(element, name);
        if (element.isJsonPrimitive()) {
            return RandomItem.constant(result);
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid RandomItem at '" + name + "', must be a string or an object");
        }
        JsonObject object2 = element.getAsJsonObject();
        if (object2.has("min")) {
            return RandomItem.range(result, GsonHelper.m_13927_((JsonObject)object2, (String)"min"));
        }
        if (object2.has("chance")) {
            return RandomItem.chance(result, GsonHelper.m_13915_((JsonObject)object2, (String)"chance"));
        }
        return RandomItem.constant(result);
    }

    public static RandomItem read(FriendlyByteBuf buffer) {
        ItemOutput result = ItemOutput.read((FriendlyByteBuf)buffer);
        RandomType type = (RandomType)buffer.m_130066_(RandomType.class);
        switch (type) {
            case RANGE: {
                int min = buffer.m_130242_();
                return RandomItem.range(result, min);
            }
            case CHANCE: {
                float chance = buffer.readFloat();
                return RandomItem.chance(result, chance);
            }
        }
        throw new DecoderException("Invalid random type " + type + " for RandomItem");
    }

    private static class Range
    extends RandomItem {
        private final ItemOutput result;
        private final int minCount;

        @Override
        public ItemStack get(Random random) {
            ItemStack result = this.result.get();
            int newCount = result.m_41613_();
            if (result.m_41613_() > this.minCount && (newCount = this.minCount + random.nextInt(result.m_41613_() - this.minCount)) <= 0) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)result, (int)newCount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize(true);
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("min", (Number)this.minCount);
            object.addProperty("max", (Number)GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1));
            object.remove("count");
            return object;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            this.result.write(buffer);
            buffer.m_130068_((Enum)RandomType.RANGE);
            buffer.m_130130_(this.minCount);
        }

        public Range(ItemOutput result, int minCount) {
            this.result = result;
            this.minCount = minCount;
        }
    }

    private static class Chance
    extends RandomItem {
        private final ItemOutput result;
        private final float chance;

        @Override
        public ItemStack get(Random random) {
            if (this.chance >= 1.0f || random.nextFloat() < this.chance) {
                return this.result.get().m_41777_();
            }
            return ItemStack.f_41583_;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object;
            JsonElement resultElement = this.result.serialize(true);
            if (this.chance >= 1.0f) {
                return resultElement;
            }
            if (resultElement.isJsonPrimitive()) {
                object = new JsonObject();
                object.add("item", resultElement);
            } else {
                object = resultElement.getAsJsonObject();
            }
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            return object;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            this.result.write(buffer);
            buffer.m_130068_((Enum)RandomType.CHANCE);
            buffer.writeFloat(this.chance);
        }

        public Chance(ItemOutput result, float chance) {
            this.result = result;
            this.chance = chance;
        }
    }

    private static enum RandomType {
        RANGE,
        CHANCE;

    }
}

