/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.IBlockSerializer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.plugin.jsonthings.block.FlexBurningLiquidBlock;
import slimeknights.tconstruct.plugin.jsonthings.block.FlexMobEffectLiquidBlock;

public class FlexBlockTypes {
    private static Supplier<FlowingFluid> fluidSupplier(ResourceLocation name) {
        return Lazy.of(() -> {
            Object patt1670$temp = Loadables.FLUID.fromKey(name, "fluid");
            if (patt1670$temp instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)patt1670$temp;
                return flowing;
            }
            throw new RuntimeException("LiquidBlock requires a flowing fluid");
        });
    }

    public static void init() {
        FlexBlockTypes.register("burning_liquid", data -> {
            ResourceLocation fluidField = (ResourceLocation)Loadables.RESOURCE_LOCATION.getOrDefault(data, "fluid", null);
            int burnTime = GsonHelper.m_13927_((JsonObject)data, (String)"burn_time");
            float damage = GsonHelper.m_13915_((JsonObject)data, (String)"damage");
            return (props, builder) -> {
                final List _properties = builder.getProperties();
                return new FlexBurningLiquidBlock(props, builder.getPropertyDefaultValues(), FlexBlockTypes.fluidSupplier(Objects.requireNonNullElse(fluidField, builder.getRegistryName())), burnTime, damage){

                    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
                        super.m_7926_(stateBuilder);
                        _properties.forEach(xva$0 -> stateBuilder.m_61104_(new Property[]{xva$0}));
                    }
                };
            };
        }, Material.f_76307_);
        FlexBlockTypes.register("mob_effect_liquid", data -> {
            ResourceLocation fluidField = (ResourceLocation)Loadables.RESOURCE_LOCATION.getOrDefault(data, "fluid", null);
            ResourceLocation effectName = (ResourceLocation)Loadables.RESOURCE_LOCATION.getIfPresent(data, "effect");
            int effectLevel = GsonHelper.m_13927_((JsonObject)data, (String)"burn_time");
            return (props, builder) -> {
                final List _properties = builder.getProperties();
                Lazy effect = Lazy.of(() -> (MobEffect)Loadables.MOB_EFFECT.fromKey(effectName, "effect"));
                return new FlexMobEffectLiquidBlock(props, builder.getPropertyDefaultValues(), FlexBlockTypes.fluidSupplier(Objects.requireNonNullElse(fluidField, builder.getRegistryName())), () -> new MobEffectInstance((MobEffect)effect.get(), 100, effectLevel - 1)){

                    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
                        super.m_7926_(stateBuilder);
                        _properties.forEach(xva$0 -> stateBuilder.m_61104_(new Property[]{xva$0}));
                    }
                };
            };
        }, Material.f_76305_);
    }

    private static <T extends Block> void register(String name, IBlockSerializer<T> factory, Material defaultMaterial) {
        FlexBlockType.register((String)TConstruct.resourceString(name), factory, (String)"translucent", (boolean)true, (Material)defaultMaterial, (Property[])new Property[0]);
    }
}

