/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class PartRecipeBuilder
extends AbstractRecipeBuilder<PartRecipeBuilder> {
    private final IMaterialItem output;
    private final int outputAmount;
    private int cost = 1;
    private ResourceLocation pattern = null;
    private Ingredient patternItem = IPartBuilderRecipe.DEFAULT_PATTERNS;

    public static PartRecipeBuilder partRecipe(IMaterialItem output) {
        return PartRecipeBuilder.partRecipe(output, 1);
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, Registry.f_122827_.m_7981_((Object)this.output.m_5456_()));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.outputAmount <= 0) {
            throw new IllegalStateException("recipe " + id + " must output at least 1");
        }
        if (this.cost <= 0) {
            throw new IllegalStateException("recipe " + id + " has no cost associated with it");
        }
        if (this.pattern == null) {
            throw new IllegalStateException("recipe " + id + " has no pattern associated with it");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "parts");
        consumerIn.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new PartRecipe(id, this.group, new Pattern(this.pattern), this.patternItem, this.cost, this.output, this.outputAmount), PartRecipe.LOADER, advancementId));
    }

    private PartRecipeBuilder(IMaterialItem output, int outputAmount) {
        this.output = output;
        this.outputAmount = outputAmount;
    }

    public static PartRecipeBuilder partRecipe(IMaterialItem output, int outputAmount) {
        return new PartRecipeBuilder(output, outputAmount);
    }

    public PartRecipeBuilder setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public PartRecipeBuilder setPattern(ResourceLocation pattern) {
        this.pattern = pattern;
        return this;
    }

    public PartRecipeBuilder setPatternItem(Ingredient patternItem) {
        this.patternItem = patternItem;
        return this;
    }
}

