/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.field;

import com.google.gson.JsonElement;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;

public class CompactSetLoadable<T>
implements Loadable<Set<T>> {
    private final Loadable<T> base;
    private final Loadable<Set<T>> setLoadable;

    public CompactSetLoadable(Loadable<T> base, boolean allowEmpty) {
        this.base = base;
        this.setLoadable = base.set(allowEmpty ? 0 : 1);
    }

    public Set<T> convert(JsonElement element, String key) {
        if (!element.isJsonArray()) {
            return Set.of(this.base.convert(element, key));
        }
        return (Set)this.setLoadable.convert(element, key);
    }

    public JsonElement serialize(Set<T> collection) {
        JsonElement element;
        if (collection.size() == 1 && !(element = this.base.serialize(collection.iterator().next())).isJsonArray()) {
            return element;
        }
        return this.setLoadable.serialize(collection);
    }

    public Set<T> decode(FriendlyByteBuf buffer) {
        return (Set)this.setLoadable.decode(buffer);
    }

    public void encode(FriendlyByteBuf buffer, Set<T> value) {
        this.setLoadable.encode(buffer, value);
    }
}

