/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.gadgets.entity.FancyItemFrameEntity;
import slimeknights.tconstruct.gadgets.entity.FrameType;

public class FancyItemFrameRenderer<T extends FancyItemFrameEntity>
extends ItemFrameRenderer<T> {
    public static final Map<FrameType, ResourceLocation> LOCATIONS_MODEL = new EnumMap<FrameType, ResourceLocation>(FrameType.class);
    public static final Map<FrameType, ResourceLocation> LOCATIONS_MODEL_MAP = new EnumMap<FrameType, ResourceLocation>(FrameType.class);

    public FancyItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(T frame, BlockPos pPos) {
        int baseLight = super.m_6086_(frame, pPos);
        return ((FancyItemFrameEntity)((Object)frame)).getFrameType() == FrameType.MANYULLYN ? Math.max(7, baseLight) : baseLight;
    }

    public void render(T frame, float entityYaw, float partialTicks, PoseStack matrices, MultiBufferSource bufferIn, int packedLight) {
        boolean frameVisible;
        FrameType frameType = ((FancyItemFrameEntity)((Object)frame)).getFrameType();
        RenderNameTagEvent renderNameplate = new RenderNameTagEvent(frame, frame.m_5446_(), (EntityRenderer)this, matrices, bufferIn, packedLight, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplate);
        if (renderNameplate.getResult() == Event.Result.ALLOW || renderNameplate.getResult() != Event.Result.DENY && this.m_6512_((ItemFrame)frame)) {
            this.m_7649_((ItemFrame)frame, renderNameplate.getContent(), matrices, bufferIn, packedLight);
        }
        matrices.m_85836_();
        Direction facing = frame.m_6350_();
        Vec3 offset = this.m_7860_((ItemFrame)frame, partialTicks);
        matrices.m_85837_((double)facing.m_122429_() * 0.46875 - offset.m_7096_(), (double)facing.m_122430_() * 0.46875 - offset.m_7098_(), (double)facing.m_122431_() * 0.46875 - offset.m_7094_());
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(frame.m_146909_()));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - frame.m_146908_()));
        ItemStack stack = frame.m_31822_();
        boolean isMap = !stack.m_41619_() && stack.m_41720_() instanceof MapItem;
        boolean bl = frameVisible = !frame.m_20145_() && (frameType != FrameType.CLEAR || stack.m_41619_());
        if (frameVisible) {
            matrices.m_85836_();
            matrices.m_85837_(-0.5, -0.5, -0.5);
            this.f_234645_.m_110937_().m_111067_(matrices.m_85850_(), bufferIn.m_6299_(Sheets.m_110790_()), null, this.f_234645_.m_110907_().m_110881_().getModel(isMap ? LOCATIONS_MODEL_MAP.get((Object)frameType) : LOCATIONS_MODEL.get((Object)frameType)), 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.f_118083_);
            matrices.m_85849_();
        }
        if (!stack.m_41619_()) {
            matrices.m_85837_(0.0, 0.0, 0.4375);
            MapItemSavedData mapdata = null;
            if (isMap) {
                mapdata = MapItem.m_42853_((ItemStack)stack, (Level)((FancyItemFrameEntity)((Object)frame)).f_19853_);
            }
            int frameRotation = frame.m_31823_();
            if (frameType == FrameType.DIAMOND) {
                rotation = mapdata != null ? (frameRotation + 2) % 4 * 4 : frameRotation;
                matrices.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation * 360.0f / 16.0f));
            } else {
                rotation = mapdata != null ? (frameRotation + 2) % 4 * 2 : frameRotation;
                matrices.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation * 360.0f / 8.0f));
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent(frame, (ItemFrameRenderer)this, matrices, bufferIn, packedLight))) {
                if (mapdata != null) {
                    matrices.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                    matrices.m_85837_(-64.0, -64.0, -1.0);
                    int light = frameType == FrameType.MANYULLYN ? 0xF000F0 : packedLight;
                    Integer mapId = MapItem.m_151131_((ItemStack)stack);
                    assert (mapId != null);
                    Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(matrices, bufferIn, mapId.intValue(), mapdata, true, light);
                } else {
                    float scale = frameType == FrameType.CLEAR ? 0.75f : 0.5f;
                    matrices.m_85841_(scale, scale, scale);
                    int light = frameType == FrameType.MANYULLYN ? 0xF000F0 : packedLight;
                    this.f_115047_.m_174269_(stack, ItemTransforms.TransformType.FIXED, light, OverlayTexture.f_118083_, matrices, bufferIn, frame.m_19879_());
                }
            }
        }
        matrices.m_85849_();
    }

    static {
        for (FrameType type : FrameType.values()) {
            String name = type == FrameType.REVERSED_GOLD ? FrameType.GOLD.m_7912_() : type.m_7912_();
            LOCATIONS_MODEL.put(type, TConstruct.getResource("block/frame/" + name));
            LOCATIONS_MODEL_MAP.put(type, TConstruct.getResource("block/frame/" + name + "_map"));
        }
    }
}

